/* Program to load bmp files ( 1 bit,4 bit and 16 bit) - Non compressed
  You are free to use this file. I do not expect any money from you.
  All I want you to do is to keep this program header with it.

 Important :
 ----------
  You need to have SVGA256.bgi in the same directory as this file.

 Programmed by G.Anil kumar,Madras,India
 Programmed on 12-10-98


Contact information
-------------------

Please feel free to report any bugs, comments, or questions that you may
have to:

  - ganilk@hotmail.com

If I find that there are bugs, I will do my best to correct them and make
the new version of the program avavilable.  I hope that this utility will
help somebody out there.  :)
*/
#include<iostream.h>
#include<fstream.h>
#include<graphics.h>
#include<conio.h>
#include<string.h>
int huge detectSVGA(void)
{
	return(2);
}
void init_graphics()
{
	int gdriver,gmode;
	gdriver=installuserdriver("SVGA256",detectSVGA);
	gdriver=DETECT;
	gmode=1;
	initgraph(&gdriver,&gmode,"");
}
void close_graphics()
{
	if (!getch()) getch();
	closegraph();
}
class bitmap
{
  private :
  int x,y;
  unsigned char color;
  fstream file;
  char *filepath;
  struct bitmapfileheader
  {
	char bftype[2];  	// File type - should be "BM" for BMP files
	long bfsize;	  	// File size
	char bfreserved1[2];  	// Reserved
	char vfreserved2[2];	// Reserved
	long bfoffbits;		// offset from beginning of file to bitmap data
  } bmfh;
  struct bitmapinfoheader
  {
	long bisize;		// Size of BITMAPINFOHEADER structure
	long biwidth;		// Width of image
	long biheight;		// Height of image
	int biplanes; 		// No. of planes
	int bibitcount;		// No. of bpi
	long bicompression;	// Type of compression
	long bisizeimage;     	// Size of image data in bytes
	long bixpelspermeter; 	// Horizontal pixels per meter
	long biypelspermeter; 	// Vertical pixels per meter
	long biclrused;       	// No. of colors used
	long biclrimportant;  	// No. of important colors
  } bmih;
  struct rgbquad
  {
	unsigned char rgbblue;   // Blue part
	unsigned char rgbgreen;  // Green part
	unsigned char rgbred;    // Red part
	unsigned char rgbreserved;
  } rgb;

  void put_pixel(int &x,int &y,unsigned char &color,int bitno)
  {
      if (color>=bitno)
      {
	    putpixel(x,y,2);
	    color-=bitno;
      }
      else putpixel(x,y,1);
      x++;
  }
  int power(int no)      //  returns 2 to the power 'no.'
  {
	int prod=1;
	for (int i=1;i<=no;i++)
		prod*=2;
	return(prod);
  }
  void show_message(char *string)
  {
	cout<<string;
  }
  int open_file()
  {
	file.open(filepath,ios::in|ios::binary);
	if (file.fail())  return(0); else return(1);
  }
  void load_palette()
  {
	for (int i=1;i<=bmih.biclrused;i++)    // loading palette
	{
	   file.read((char *)&rgb,sizeof(rgb));
	   setrgbpalette(i,rgb.rgbred>>2,rgb.rgbgreen>>2,rgb.rgbblue>>2);
	}
  }
  void show_one_bit_bitmap()
  {

	   y=bmih.biheight;
	   x=1;
	   while(!file.eof())
	   {
		int maxx=bmih.biwidth;
		file.read((char *)&color,sizeof(color));
		put_pixel(x,y,color,128);
		put_pixel(x,y,color,64);
		put_pixel(x,y,color,32);
		put_pixel(x,y,color,16);
		if (x>maxx) { x=1;y--; }
		put_pixel(x,y,color,8);
		put_pixel(x,y,color,4);
		put_pixel(x,y,color,2);
		put_pixel(x,y,color,1);
		if (x>maxx) { x=1;y--; }
	   }
  }
  void show_four_bit_bitmap()
  {
	   y=bmih.biheight;
	   x=1;
	   int maxx=bmih.biwidth;
	   file.read((char *)&color,sizeof(color));
	   while(!file.eof())
	   {
		putpixel(x,y,(color>>4)+1);x++;
		if (x>maxx) { x=1;y--; }
		if (color>=128) color-=128;
		if (color>=64) color-=64;
		if (color>=32) color-=32;
		if (color>=16) color-=16;
		putpixel(x,y,color+1);x++;
		if (x>maxx) { x=1;y--; }
		file.read((char *)&color,sizeof(color));
	   }
  }
  void show_eight_bit_bitmap()
  {
	   for (y=bmih.biheight;y>=1;y--)
	   {
		for (x=1;x<=bmih.biwidth;x++)
		{
			file.read((char *)&color,sizeof(color));
			putpixel(x,y,color+1);
		}
		if (bmih.biwidth%4!=0)
		{
			for (int x=bmih.biwidth%4;x<4;x++)
			  file.read((char *)&color,sizeof(color));
		}
	   }
  }
  public :
  bitmap(char *fpath)
  {
	strcpy(filepath,fpath);
  }
  void show_bmp()
  {
	if (!open_file())
	{
		show_message("Invalid file");
		return;
	}
	file.read((char *)&bmfh,sizeof(bmfh));
	file.read((char *)&bmih,sizeof(bmih));
	if (bmfh.bftype[0]!='B' | bmfh.bftype[1]!='M' )
	{
		show_message("Not a bmp file");
		file.close();
		return;
	}
	if (bmih.bicompression)
	{
		show_message("Cannot load compressed images");
		file.close();
		return;
	}
	if (bmih.biclrused==0) bmih.biclrused=power(bmih.bibitcount);
	if (bmih.bibitcount==24)
	{
		show_message("Cannot load 24-bit BMP.");
		file.close();
		return;
	}
	init_graphics();
	load_palette();
	if (bmih.bibitcount==1)			// 2 color bmp
		show_one_bit_bitmap();
	if (bmih.bibitcount==4)			// 16-color bmp
		show_four_bit_bitmap();
	if (bmih.bibitcount==8)			// 256-color bmp
		show_eight_bit_bitmap();
	close_graphics();
  }
};
void main()
{

	char *fpath="";
	clrscr();
	cout<<"Enter file path : ";
	cin>>fpath;
	bitmap bmp(fpath);
	bmp.show_bmp();
}
