// created by akbar A.
#include <GL/glut.h>
#include <windows.h>
#include <malloc.h>
#include "gli.h"
#include "types.h"


void calc_midpoints();
void keyboard(unsigned char key, int x, int y);

float tmp;
gliGenericImage *tex;
GLuint tex_name;


#ifndef GL_EXT_texture
#define glBindTextureEXT	glBindTexture
#endif


int shading_model = 0;
int active;
int winWidth  = 640;
int winHeight = 480;
int rotation_mode = 0;

GLfloat smear_lr = 1.0, smear_updown = 1.0;
GLfloat smear_X = 1.0 , smear_Y = 1.0, smear_Z = 1.0;

int screen_midpoints[2];
int screen_prev_x, screen_prev_y;
int smear_modes[2];
int wire_mode , wire_set = 0;
float rotation_values[] = {0.0, 0.0};






GLfloat material_spec[] = {1.0, 0.0, 1.0, 1.0};
GLfloat mat_shiny[] = {80.0};
GLfloat light_pos[] = {0.0, 1.0, 1.0, 1.0};
GLfloat yellow_light[] = {1.0, 0.0, 0.0, 1.0};
GLfloat idle_x = 0;
GLfloat idle_y = 0;



extern void free_ants();
void init(void)
{
	GLubyte *pixels;
	tex = readImage("map2.tga");
	pixels = (GLubyte *)malloc(256*256*4);
	
	
	if(tex == NULL)	{
		printf("error loading map\n");
		exit(1);
	}
	
	
	
	pixels = tex->pixels;
	
	//glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	
	
	glGenTextures(1, &tex_name);
	glBindTexture(GL_TEXTURE_2D, tex_name);
	
	
	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	
	
	gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGBA,
		GL_UNSIGNED_BYTE, pixels);
	
	free(tex);
	
	
	
	glClearColor(0.20, 0.20, 0.20, 0.0);

	glShadeModel(GL_SMOOTH);
	glEnable(GL_DEPTH_TEST);
	glCullFace(GL_BACK);
	
	
	mat_shiny[0] = 150.0;
	
	
	glMaterialfv(GL_FRONT, GL_SPECULAR, material_spec);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shiny);
	glLightfv(GL_LIGHT0, GL_POSITION, light_pos);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, yellow_light);
	glLightfv(GL_LIGHT0, GL_SPECULAR, yellow_light);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	
	
	calc_midpoints();
	
	
	
	
	
	
	
}



extern void r_model();
int free_rotate  = 0;
void idle(void)
{
	if(free_rotate == (int) 1)	{
		glRotatef(idle_x, 0.0, 1.0, 0.0);
		glRotatef(idle_y , 1.0, 0.0, 0.0);
		
		glutPostRedisplay();
	}
	
	
}



void calc_midpoints()
{
	screen_midpoints[0] = winWidth /2;
	screen_midpoints[1] = winHeight/2;
}


void menu(int option)
{
	keyboard((unsigned char) option, 0, 0);
}

// smear and mouse controly rotation
void smear(int x, int y)
{
	
	smear_lr = (x - winWidth/2) * 5./winWidth;
	smear_updown = (y - winHeight/2) * 5./winHeight;
	
	
	idle_x = (x - screen_prev_x) / 100;
	idle_y = (y - screen_prev_y) / 100;
	
	if(rotation_mode == (int) 0)	{
		
		if(smear_modes[0] == (int) 1)
			smear_X = smear_lr;
		
		
		if(smear_modes[1] == (int) 1)
			smear_Y = smear_updown;
	}
	
	if(rotation_mode == (int) 1)	{
		rotation_values[0] = (x - winWidth/2) * 360./winWidth;
		rotation_values[1] = (y - winHeight/2) * 360./winHeight;
	}
	
	
	
	
	glutPostRedisplay();
}





void
mouse(int button, int state, int x, int y) {
	
	/* hack for 2 button mouse */
	if (button == GLUT_LEFT_BUTTON && glutGetModifiers() & GLUT_ACTIVE_SHIFT)
		button = GLUT_MIDDLE_BUTTON;
	
	if(state == GLUT_DOWN) {
		
		switch(button) 
		{
			
		case GLUT_LEFT_BUTTON:
			if(rotation_mode == (int) 0)	{
				
				if(x > screen_prev_x)
					active = smear_updown;
				if(x < screen_prev_x)
					active = smear_lr;
				
				smear(x, y);
			}
			if(rotation_mode == (int) 1)	{
			}
			
			
			
			
			break;
			
			
		}
		
	} 
	
	screen_prev_x = x;
	screen_prev_y = y;
	
	
}



int frame_count = 0;



extern void render_text();



void display(void)
{
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	glColor3f(0.0, 1.0, 0.0);
	
	
	
	
	
	
	glPushMatrix();
	glRotatef(rotation_values[0], 0.0, 1.0, 0.0);
	glRotatef(rotation_values[1], 1.0, 0.0, 0.0);
	
	
	glScalef(smear_X, smear_Y, 1.0);
	
	glEnable(GL_TEXTURE_2D);
	
	
	glBindTexture(GL_TEXTURE_2D, tex_name);
	
	
	glEnable(GL_TEXTURE_GEN_S);
	glEnable(GL_TEXTURE_GEN_T);
	glScalef(0.03, 0.03, 0.03);
//	glDisable(GL_TEXTURE_2D);
	

	
	
	//ChamferBox();

	
	
	r_model();
	
	
	
	
	
	glPopMatrix();
	glDisable(GL_TEXTURE_GEN_S);
	glDisable(GL_TEXTURE_GEN_T);
	
	
	frame_count = 1;

	
	glutSwapBuffers();
	
	
	
}












void reshape(int w, int h)
{
	winWidth = w;
	winHeight = h;
	glViewport(0, 0, (GLsizei) w, (GLsizei) h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, (GLfloat) w/ (GLfloat) h, 1.0, 20.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 0.0, 5.0, 0.0, 0.0, 0.0,0.0,  1.0, 0.0);

}



extern int draw_normals;
extern int draw_object;
int help = false;
int texture_mode = TRUE;
int light_mode = FALSE;




void keyboard(unsigned char key, int x, int y)
{
	switch(key)	{
	case 'f':
		free_rotate = !free_rotate;
		glutPostRedisplay();
		break;
	case 'y':
		smear_modes[1] = !smear_modes[1];
		if(smear_modes[0] == (int)1)
			smear_modes[0] = 0;
		
		
		glutPostRedisplay();
		break;
	case 'x':
		smear_modes[0] = !smear_modes[0];
		if(smear_modes[1] == (int )1)
			smear_modes[1] = 0;
		glutPostRedisplay();
		break;
	case 'b':
		smear_modes[0] = 1;
		smear_modes[1] = 1;
		glutPostRedisplay();
		break;
		
		
	case 'w':
		wire_mode = !wire_mode;
		
		if(wire_mode == (int) 1)	{
			glEnable(GL_DEPTH_TEST);
			glPolygonMode(GL_FRONT, GL_LINE);
			glPolygonMode(GL_BACK, GL_LINE);
			glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
			glLineWidth(1.0);
			
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			
		}
		else	{
			/*
			glDisable(GL_LINE_SMOOTH);
			glDisable(GL_BLEND);
			glEnable(GL_TEXTURE_2D);
			*/
			glEnable(GL_POLYGON_SMOOTH);		
			glPolygonMode(GL_FRONT, GL_FILL);
			glPolygonMode(GL_BACK, GL_FILL);

			glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

			
			
			
		}
		
		glutPostRedisplay();
		break;
	case 's':
		shading_model = !shading_model;
		if(shading_model == (int) 0)
			glShadeModel(GL_FLAT);
		if(shading_model == (int) 1)
			glShadeModel(GL_SMOOTH);
		glutPostRedisplay();
		break;
		
	case 'r':
		rotation_mode = !rotation_mode;
		glutPostRedisplay();
		break;
	case 'c':
		draw_normals = !draw_normals;
		break;
	case 'o':
		draw_object = !draw_object;
		break;
	case 'q':
		free_ants();
		//kill_vars();
		exit(1);
		break;
	case 'h':
		help = !help;
		break;
	case 't':
		texture_mode = !texture_mode;
		break;	

	case 'l':
		light_mode = !light_mode;
		break;
		
	default:
		break;
	}
}


void load_ase_file(char *name);
extern void dump_norm();
extern void dump_vnormal();


char *ase_file;
char *morph_too;
int f_spec = 0;


void init_strings()
{
	ase_file = (char *)malloc(sizeof(char));
	morph_too = (char *)malloc(sizeof(char));
}


void val_args(int argc, char **argv)
{
	int i = 1;

	for(i; i < argc; i++)	{
		if(strcmp(argv[i], "-m") == 0)	{
			ase_file = argv[++i];
			printf("Model to load = %s\n", argv[i]);
			f_spec = 1;
		}

		if(strcmp(argv[i], "-morph") == 0)	{
			if(!f_spec)	{	
				printf("Must specify first model if choosing morph option\n");
				exit(1);
			}
			morph_too = argv[++i];
			printf("model to morph too %s\n", argv[i]);
		}

		if( ((strcmp(argv[i], "-h") == 0)) || (strcmp(argv[i], "help") == 0))	{
			printf("Help Option	**************\n\t-m specfies model to load\n\t-morph specfies which model to morph too\n");

			exit(1);
		}

	}


}


extern LPMEMORYSTATUS mem_stat;

void init_crap()
{
//	t = (float *)malloc(sizeof(float)); u = (float *)malloc(sizeof(float)); 
//	v = (float *)malloc(sizeof(float));

	mem_stat = malloc((MEMORYSTATUS * )sizeof(MEMORYSTATUS));
}

int help;


int main(int argc, char **argv)
{

	init_strings();
	init_crap();
	val_args(argc, argv);


	if(f_spec)
		load_ase_file(ase_file);
	else
		load_ase_file("simple.ase");




	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
	glutInitWindowSize(winWidth, winHeight);
	glutCreateWindow("various stuff- vertex colors - ASE files");
	init();
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutMouseFunc(mouse);
	glutMotionFunc(smear);
	glutKeyboardFunc(keyboard);
	glutIdleFunc(idle);
	
	
	
	glutCreateMenu(menu);
	glutAddMenuEntry("smear Y' axis", 'y');
	glutAddMenuEntry("smear X' axis", 'x');
	glutAddMenuEntry("smear both' axis", 'b');
	glutAddMenuEntry("wire mode; adds AA", 'w');
	glutAddMenuEntry("change shading model", 's');

	glutAddMenuEntry("Draw Normals", 'c');
	glutAddMenuEntry("Draw Objects", 'o');
		
	glutAddMenuEntry("free/motion rotate mode", 'f');
	glutAddMenuEntry("rotation mode", 'r');
	

	
	

	glutAddMenuEntry("------------------", ' ');
	glutAddMenuEntry("Change texture map mode", 't');
	glutAddMenuEntry("Alter Light Model", 'l');

	glutAddMenuEntry("Sequence of 0's and 1's Copyright (C) 2000 akbar A.", ' ');
	glutAttachMenu(GLUT_RIGHT_BUTTON);
	
	dump_info();
	dump_norm();
	dump_vnormal();
	glutMainLoop();
	


	
	return 0;
}









