
/* loadtex.c - texture object loaded for OpenGL using GLI routines */

/* Copyright NVIDIA Corporation, 2000. */

/* $Id: //sw/main/apps/OpenGL/mjk/md2shader/loadtex.c#4 $ */

#include <stdlib.h>
#include <stdio.h>

#include "gli.h"
#include "loadtex.h"

gliGenericImage *
readImage(char *filename)
{
  FILE *file;
  gliGenericImage *image;
  int yFlip = 1;

  file = fopen(filename, "rb");
  if (file == NULL) {
    printf("could not open \"%s\"\n", filename);
    exit(1);
  }

    fseek(file, 0L, SEEK_SET);
    image = gliReadTGA(file, filename, yFlip);
    if (image == NULL) {
      printf("not TGA or PCX image\n", filename);
      exit(1);
    }
  
  fclose(file);
  return image;
}

static int
roundUp(int v)
{
  int i;

  for (i=0; i<31; i++) {
    if (v <= (1<<i)) {
      return 1<<i;
    }
  }
  return 1<<31;
}
