// copyright (C) 2000 akbar A
#include <GL/glut.h>
#include <math.h>
#include <malloc.h>
#include <windows.h>

#include "types.h"
#include "collision.h"

extern int max_faces;
extern struct face *face_list;

extern struct d_data *v_data;	// per vertex
extern struct face *face_list;
extern struct t_list *txt_list;		// texture list
extern struct v_color *vcolor;

LPMEMORYSTATUS mem_stat;



extern int max_vert;
extern int v_pos;
extern int m_pos;
extern int f_pos;
extern int max_faces;
extern int l_mvertexnorm;	// hackish?
extern int vn_tracker;

extern int max_color_vert;
float ramp_val[512];
int hit = false;


#ifndef false
#define false 0
#define true 1
#endif


int draw_normals = false;
int draw_object = true;

static void init_ramp()
{
	int i;
	for(i = 0; i < 256; i++)	{
		ramp_val[i] = i;
		ramp_val[i] /= 256;
	}
	
}


void free_ants()
{
	printf("free ants\n");
	free(face_list);
	free(v_data);
	free(txt_list);
	free(vcolor);
}






void mul_factor(vec3f *val, float amt, vec3f place)
{
/*
place[0] = val[0];// * amt;
place[0] = val[1];// * amt;
place[0] = val[2];// * amt;
	*/
}


void flag_hack()
{
	int i = 0;
	for(i; i < max_faces; i++)	{
		//		v_data[face_list[i].vnorm_seq[2]].normal[0] = -v_data[face_list[i].vnorm_seq[2]].normal[0];
		//		v_data[face_list[i].vnorm_seq[2]].normal[1] = -v_data[face_list[i].vnorm_seq[2]].normal[1];
		v_data[face_list[i].vnorm_seq[2]].normal[2] = -v_data[face_list[i].vnorm_seq[2]].normal[2];
	}
	
}




//v_data[face_list[i].vnorm_seq[2]].normal




void div_factor(vec3f val, float amt)
{
	val[0] /= amt;
	val[1] /= amt;
	val[2] /= amt;
}


void enableAA();
void disableAA();

#define REV(a) { a[0] = -a[0]; a[1] = -a[1]; a[2] = -a[2];}
#define MUL(a,b) { a[0] *=b; a[1] *= b; a[2] *= b;}
#define CPY(a,b) { a[0] =b[0]; a[1]=b[1];a[2]=b[2];}
#define ADD(a,b) {a[0] += b; a[1] += b; a[2] += b;}
#define ADDV(a,b) { a[0] += b[0]; a[1] += b[1]; a[2] += b[2];}
#define SUBV(a,b) { a[0] -= b[0]; a[1] -= b[1]; a[2] -= b[2]; }



#include "font.h"
extern int winHeight;
extern int winWidth;
void render_text()
{
	glDisable(GL_LIGHTING);
  
	glColor3f(1.0, 1.0, 0.0);
	if(hit == 1)
		output(10, winHeight - 20 , "Intersection Occured");
	if(hit == 0)
		output(10, winHeight - 20 , "No Intersection");



}


void mini_kernel()
{
		GlobalMemoryStatus(mem_stat);
	glColor3f(1.0, 1.0, 0.0);
	output(10, winHeight - 20 , "faces in mesh = %i", max_faces);
	output(10, winHeight - 35 , "vertices in mesh = %i", max_vert);
	output(10, winHeight - 70, "memory usage of vertex data (v_data) = %ik", sizeof(v_data) * max_vert);
	output(10, winHeight - 90, "memory usage of vertex color (v_color) = %ik", sizeof(vcolor) * max_color_vert);

	/*
	output(10, winHeight - 110, "Cpu Mem Load = %u",   mem_stat->dwMemoryLoad);
	printf(10, winHeight - 130,"Bytes of Physical memory %i\n", mem_stat->dwTotalPhys/1000);
	printf(10, winHeight - 150,"Free user bytes %i\n", mem_stat->dwAvailVirtual/1000);
	*/
	glColor3f(1.0, 0.0, 0.0);
	output(10, winHeight - 110, "physical memory installed = %uk", mem_stat->dwTotalPhys/1000);
	output(10, winHeight - 130, "physical memory available = %uk", /*(mem_stat->dwTotalPhys -*/ mem_stat->dwAvailPhys/1000);
	output(10, winHeight - 150, "approx MEM usage = %u percent", mem_stat->dwMemoryLoad );























}










#define AVG(a,b,c) { c[0] = ((a[0]*b[0])/2); c[1] = ((a[1]*b[1])/2); c[2] = ((a[2]*b[2])/2); };

extern int help;

void render_help()
{
	glColor3f(0.0, 1.0, 0.0);
	if(help == true)
		output(10, winHeight - 170, "Hit right click for options menu");
}


int color_vertex = true;


void enable_wire()
{
	glEnable(GL_DEPTH_TEST);
	glPolygonMode(GL_FRONT, GL_LINE);
	glPolygonMode(GL_BACK, GL_LINE);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	glLineWidth(2.0);
			
}

void disable_wire()
{
	glEnable(GL_POLYGON_SMOOTH);		
	glPolygonMode(GL_FRONT, GL_FILL);
	glPolygonMode(GL_BACK, GL_FILL);

	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
			
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


}

extern int texture_mode;
extern int light_mode;


void r_model()
{
	int i = 0;
	//vec3f v1,v2,v3;
	int pos[3];
	int norm_track[3];
	vec3f tmp;
	vec3f vnorm;
	vec3f box_tmp;
	vec3f ctmp;	// color tmp
	vec3i cpos;
		
	int itmp;
	int hpoint;
	float other = 0;
	float length;
	
	static float cval = 0;
	static int red_mode = 1;
	static int theta = 1;
	vec3f ray_start, ray_end;
	vec3f n_face;
		
	float *t, *u, *v;
	t = (float *)malloc(sizeof(float)); u = (float *)malloc(sizeof(float)); 
	v = (float *)malloc(sizeof(float));

	
	SET(ray_start, 10.0, 5.0, 0.0);
	SET(ray_end, 5.0, 1.0, 0.0);
	

	
	
	init_ramp();
	

	
	
	
	
	

	
	if(texture_mode)
		glEnable(GL_TEXTURE_2D);
	else
		glDisable(GL_TEXTURE_2D);
	
	if(light_mode)
		glEnable(GL_LIGHTING);
	else
		glDisable(GL_LIGHTING);


	
	glColor3f(1.0, 1.0, 0.0);
	

	
	if(draw_object)	{
		
		
		
	
		glEnable(GL_NORMALIZE);
		
		
		
		enableAA();
		glLineWidth(2);

		//glEnable(GL_RESCALE_NORMALS);
		for(i = 0; i < max_faces; i++)	{
			

				
			glBegin(GL_TRIANGLES);
			pos[0] = face_list[i].seq[0];
			pos[1] = face_list[i].seq[1];
			pos[2] = face_list[i].seq[2];
			

			if(color_vertex)	{

			cpos[0] = face_list[i].color_seq[0];
			cpos[1] = face_list[i].color_seq[1];
			cpos[2] = face_list[i].color_seq[2];
			} else	{
				cpos[0] =  0;
				cpos[1] = 0;
				cpos[2] = 0;
			}



			//if(color_vertex)
			
			
			//glNormal3fv(face_list[i].f_norm);
			
			
			

			norm_track[2] = face_list[i].v_norm[2] = 0.0;
			
			CPY(tmp, v_data[face_list[i].vnorm_seq[0]].normal);

			//AVG(v_data[cpos[0]].vcolor, v_data[cpos[1]].vcolor, ctmp);
			
			glNormal3fv(tmp);
			//glColor3fv(v_data[pos[0]].vcolor);
			if(color_vertex)	{
				CPY(ctmp, vcolor[cpos[0]].color);
				glColor3fv(ctmp);
			}

			glVertex3fv(v_data[pos[0]].vertex);

			
			
			CPY(tmp, v_data[face_list[i].vnorm_seq[1]].normal);
			glNormal3fv(tmp);	
			//AVG(v_data[pos[1]].vcolor, v_data[pos[0]].vcolor, ctmp);
			//glColor3fv(v_data[pos[1]].vcolor);
			//glColor3fv(ctmp);

			if(color_vertex)	{
				CPY(ctmp, vcolor[cpos[1]].color);
				glColor3fv(ctmp);
			}

			glVertex3fv(v_data[pos[1]].vertex);
			


			CPY(tmp, v_data[face_list[i].vnorm_seq[2]].normal);
			glNormal3fv(tmp);

			if(color_vertex)	{
				CPY(ctmp, vcolor[cpos[2]].color);
				glColor3fv(ctmp);
			}

			glVertex3fv(v_data[pos[2]].vertex);


			glEnd();
			
			
			
		}
		
				
	}
	
	// draw our line ALWAYS
	
	
	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glLineWidth(4);
	

	/*
	for(i = 0;  i < max_faces; i++)	{
		float color_draw = 1.0;
		
		static float mul_factor = 2.0;


		pos[0] = face_list[i].seq[0];
		pos[1] = face_list[i].seq[1];
		pos[2] = face_list[i].seq[2];
		
		//norm_track[2] = face_list[i].v_norm[2] = 0.0;
		
		
		
		
		
		glBegin(GL_LINES);
		
		glColor3f(0.0, 1.0, 0.0);
		CPY(ray_end, v_data[pos[2]].vertex);		// the vertex outside
		MULV(ray_end, mul_factor);
		//MULV(ray_end, 2);
		glVertex3fv(ray_end);
		mul_factor -= 0.000005;
				
		
		
		if(mul_factor < 1.0)
			mul_factor = 2.0;

		//printf("mul_factor = %f \n", mul_factor);


		CPY(ray_start, v_data[pos[2]].vertex);
		glColor3f(0.0, 0.0, 1.0);
		MULV(ray_start, 2);
		glVertex3fv(ray_start);


		glColor3f(1.0, 1.0, 0.0);
		CPY(ray_start, v_data[pos[2]].vertex);

		hit = intersect_triangle(ray_start, ray_end, v_data[pos[0]].vertex,
			v_data[pos[1]].vertex, v_data[pos[2]].vertex, t, u, v);

		glEnd();
		//printf("hit = %i\n",hit);
		if(hit == 0)	{
			//output(10, winHeight - 50 , "We have intersection? ");
		//	printf("WE HAVE INTERSECTION\n");
		}

	}

  */
	


	mini_kernel();
	
	glLineWidth(1.0);

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		glDisable(GL_LIGHTING);
		
		glLineWidth(2);
		if(draw_normals)	{
			
			
			enableAA();
			glLineWidth(3);
		
		
			for(i = 0; i < max_faces; i++)	{
				glBegin(GL_LINES);		
				
				
				pos[0] = face_list[i].seq[0];
				pos[1] = face_list[i].seq[1];
				pos[2] = face_list[i].seq[2];

				
			

				glColor3f(0.0, 1.0, 0.0);
				glVertex3fv(v_data[pos[0]].vertex);
				
				glColor3f(0.0, 0.0, 1.0);


				CPY(tmp, v_data[face_list[i].vnorm_seq[0]].normal);
				
				if(tmp[2] < 0)	{
					glColor3f(1.0, 0.0, 0.0);
					tmp[2] = -tmp[2];
					
				}
	

				ADDV(tmp, v_data[pos[0]].vertex);
				//tmp[2] = -tmp[2];
				//ADDV(tmp, v_data[pos[0]].vertex);
				MUL(tmp, 1.450);
				glVertex3fv(tmp);


				
				
				///////////////////////
				glColor3f(1.0, 1.0, 0.0);
				glVertex3fv(v_data[pos[1]].vertex);

				glColor3f(0.0, 0.0, 1.0);


				CPY(tmp, v_data[face_list[i].vnorm_seq[1]].normal);
				if(tmp[2] < 0)	{
					glColor3f(1.0, 0.0, 0.0);
					tmp[2] = -tmp[2];
				}

				ADDV(tmp, v_data[pos[1]].vertex);
				//tmp[2] = -tmp[2];
				//ADDV(tmp, v_data[pos[0]].vertex);
				MUL(tmp, 1.450);
				glVertex3fv(tmp);
				//////////////////////////



				///////////////////////////
				glColor3f(0.0, 1.0, 0.0);
				glVertex3fv(v_data[pos[2]].vertex);

				glColor3f(0.0, 0.0, 1.0);


				CPY(tmp, v_data[face_list[i].vnorm_seq[2]].normal);
				/*if(tmp[0] < 0)
					tmp[0] = -tmp[0];
				if(tmp[1] < 0)
					tmp[1] = -tmp[1];
					*/
				if(tmp[2] < 0)	{
					glColor3f(1.0, 0.0, 0.0);
					tmp[2] = -tmp[2];
				}


				ADDV(tmp, v_data[pos[2]].vertex);
				//tmp[2] = -tmp[2];
				//ADDV(tmp, v_data[pos[0]].vertex);
				MUL(tmp, 1.450);
				glVertex3fv(tmp);
				//////////////////////////




				





				/*
				glColor3f(0.0, 1.0, 0.0);
				glVertex3fv(v_data[pos[1]].vertex);
				glColor3f(1.0, 1.0, 0.0);
				CPY(tmp, v_data[face_list[i].vnorm_seq[1]].normal);
				ADDV(tmp, v_data[pos[1]].vertex);
				MUL(tmp, 1.20);
				glVertex3fv(tmp);

				glColor3f(0.0, 1.0, 0.0);
				glVertex3fv(v_data[pos[2]].vertex);
				glColor3f(1.0, 0.0, 1.0);
				CPY(tmp, v_data[face_list[i].vnorm_seq[2]].normal);
				ADDV(tmp, v_data[pos[2]].vertex);
				MUL(tmp, 2.0);
				glVertex3fv(tmp);

				*/

				glEnd();
			}

			glEnable(GL_DEPTH_TEST);
			
			
			
		}
		
		glEnable(GL_LIGHTING);



		
		render_help();
		free(t); free(u); free(v);

		
		
		
		
		
}


void enableAA()
{
/*	glPolygonMode(GL_FRONT, GL_LINE);
glPolygonMode(GL_BACK, GL_LINE);
	*/
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	
}



void disableAA()
{
	glDisable(GL_LINE_SMOOTH);
	glDisable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_POLYGON_SMOOTH);		
	glPolygonMode(GL_FRONT, GL_FILL);
	glPolygonMode(GL_BACK, GL_FILL);
}


