// misc stuff
#ifndef types_h
#define types_h


typedef float vec3f[3];
typedef float vec2f[2];
typedef int vec3i[3];

#ifndef true
#define true 1
#define false 0
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define SET(a,b,c,d) { a[0] = b; a[1] = c; a[2] = d;}
#define EPSILON 0.000001


#define CROSS(dest,v1,v2) \
	dest[0]=v1[1]*v2[2]-v1[2]*v2[1]; \
	dest[1]=v1[2]*v2[0]-v1[0]*v2[2]; \
dest[2]=v1[0]*v2[1]-v1[1]*v2[0];

#define DOT(v1,v2) ((v1[0]*v2[0])+(v1[1]*v2[1])+(v1[2]*v2[2]))

#define SUB(dest,v1,v2)\
	dest[0]=v1[0]-v2[0]; \
	dest[1]=v1[1]-v2[1]; \
dest[2]=v1[2]-v2[2];

#define CPYV(a,b) a[0] = b[0]; a[1] = b[1]; a[2] = b[2];
#define MULV(a,b) a[0] *=b; a[1] *=b; a[2] *=b;


#define REV(a) { a[0] = -a[0]; a[1] = -a[1]; a[2] = -a[2];}
#define MUL(a,b) { a[0] *=b; a[1] *= b; a[2] *= b;}
#define CPY(a,b) { a[0] =b[0]; a[1]=b[1];a[2]=b[2];}
#define ADD(a,b) {a[0] += b; a[1] += b; a[2] += b;}
#define ADDV(a,b) { a[0] += b[0]; a[1] += b[1]; a[2] += b[2];}
#define SUBV(a,b) { a[0] -= b[0]; a[1] -= b[1]; a[2] -= b[2]; }










typedef vec3f point3d;

struct	box	{
	point3d min;
	point3d max;
};

struct vertex	{
	float x;
	float y;
	float z;
};

struct v_color	{
	vec3f color;
	int pos;
};


// d_data = draw_data
// per vertex!
struct d_data	{
	vec3f vertex;
	vec3f normal;
	vec2f txt_cord;		// texture cordinates
//	vec3f vcolor;		// vertex color
	int index;
	int face_ref;	// each face has a refernce. this is where
			// the per vertex normals are used
};

struct face	{
	vec3f v1,v2,v3;
	vec3i v_norm;	// keep the number to reference
	vec3f f_norm;	//	face normal!!
	vec3i color_seq; // seqience of vertex colors.
	vec3i seq;
	vec3i vnorm_seq;
	vec3f vertex_norms[3];	// all '3' of them
	int index;
};



struct t_list	{
	vec3f seq;
	int index;
};







#endif