// learning glut menus :D
// created by akbar A.
#include <gl/glut.h>


void calc_midpoints();
void keyboard(unsigned char key, int x, int y);

float tmp;

int shading_model = 0;
int active;
int winWidth  = 640;
int winHeight = 480;

GLfloat smear_lr = 1.0, smear_updown = 1.0;
GLfloat smear_X = 1.0 , smear_Y = 1.0, smear_Z = 1.0;

int screen_midpoints[2];
int screen_prev_x, screen_prev_y;
int smear_modes[2];
int wire_mode , wire_set = 0;





GLfloat material_spec[] = {1.0, 1.0, 1.0, 1.0};
GLfloat mat_shiny[] = {80.0};
GLfloat light_pos[] = {1.0, 1.0, 1.0, 1.0};
GLfloat yellow_light[] = {1.0, 1.0, 0.0, 1.0};


void init(void)
{
	glClearColor(1.0, 1.0, 1.0, 1.0);
	glShadeModel(GL_FLAT);
	glEnable(GL_DEPTH_TEST);
	
	glMaterialfv(GL_FRONT, GL_SPECULAR, material_spec);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shiny);
	glLightfv(GL_LIGHT0, GL_POSITION, light_pos);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, yellow_light);
	glLightfv(GL_LIGHT0, GL_SPECULAR, yellow_light);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	
	calc_midpoints();
	
	
}



void test_frame_mode()
{
	if(wire_mode == (int) 1)	{
		glPolygonMode(GL_FRONT, GL_LINE);
		glPolygonMode(GL_BACK, GL_LINE);
		glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_LINE_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glLineWidth(2.0);
		wire_set = 1;
	}
	if((wire_set == 1) && (wire_mode == 0))	{
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_BLEND);
		glEnable(GL_POLYGON_SMOOTH);		
		glPolygonMode(GL_FRONT, GL_FILL);
		glPolygonMode(GL_BACK, GL_FILL);
		wire_set = 0;
	}
}



void idle(void)
{
	
	
}



void calc_midpoints()
{
	screen_midpoints[0] = winWidth /2;
	screen_midpoints[1] = winHeight/2;
}


void menu(int option)
{
	keyboard((unsigned char) option, 0, 0);
}


void smear(int x, int y)
{
	
	smear_lr = (x - winWidth/2) * 5./winWidth;
	smear_updown = (y - winHeight/2) * 5./winHeight;
	
	if(smear_modes[0] == (int) 1)
		smear_X = smear_lr;
	
	
	if(smear_modes[1] == (int) 1)
		smear_Y = smear_updown;
	
	glutPostRedisplay();
}





void
mouse(int button, int state, int x, int y) {
	
    /* hack for 2 button mouse */
    if (button == GLUT_LEFT_BUTTON && glutGetModifiers() & GLUT_ACTIVE_SHIFT)
		button = GLUT_MIDDLE_BUTTON;
	
    if(state == GLUT_DOWN) {
		
		switch(button) 
		{
			
		case GLUT_LEFT_BUTTON:
			if(x > screen_prev_x)
				active = smear_updown;
			if(x < screen_prev_x)
				active = smear_lr;
			
			smear(x, y);
			active = 9;
			break;
			
			
		}
		
	} 
	
	screen_prev_x = x;
	screen_prev_y = y;
	
	
}






void display(void)
{
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	test_frame_mode();
	
	glColor3f(0.0, 1.0, 0.0);
	
	glPushMatrix();
	glTranslatef(0.0, 0.0, -3.0);
	glScalef(smear_X, smear_Y, 1.0);
	glutSolidTeapot(1);
	glPopMatrix();
	glutSwapBuffers();
	
}



void reshape(int w, int h)
{
	glViewport(0, 0, (GLsizei) w, (GLsizei) h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, (GLfloat) w/ (GLfloat) h, 1.0, 20.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 0.0, 5.0, 0.0, 0.0, 0.0,0.0,  1.0, 0.0);
}




void keyboard(unsigned char key, int x, int y)
{
	switch(key)	{
	case 'y':
		smear_modes[1] = !smear_modes[1];
		if(smear_modes[0] == (int)1)
			smear_modes[0] = 0;
		
		glutPostRedisplay();
		break;
	case 'x':
		smear_modes[0] = !smear_modes[0];
		if(smear_modes[1] == (int )1)
			smear_modes[1] = 0;
		
		glutPostRedisplay();
		break;
	case 'b':
		smear_modes[0] = 1;
		smear_modes[1] = 1;
		glutPostRedisplay();
		break;
		
		
	case 'w':
		wire_mode = !wire_mode;
		glutPostRedisplay();
		break;
	case 's':
		shading_model = !shading_model;
		if(shading_model == (int) 0)
			glShadeModel(GL_FLAT);
		if(shading_model == (int) 1)
			glShadeModel(GL_SMOOTH);
		glutPostRedisplay();
		break;
		
		
	default:
		break;
	}
}



int main(int argc, char **argv)
{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(winWidth, winHeight);
	glutCreateWindow("various stuff");
	init();
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutMouseFunc(mouse);
	glutMotionFunc(smear);
	glutKeyboardFunc(keyboard);
	glutIdleFunc(idle);
	
	
	
	glutCreateMenu(menu);
	glutAddMenuEntry("smear Y' axis", 'y');
	glutAddMenuEntry("smear X' axis", 'x');
	glutAddMenuEntry("smear both' axis", 'b');
	glutAddMenuEntry("wire mode; adds AA", 'w');
	glutAddMenuEntry("change shading model", 's');
	
	
	glutAddMenuEntry("made by akbar A. contact: syedali011@earthlink.net ", ' ');
	glutAttachMenu(GLUT_RIGHT_BUTTON);
	
	glutMainLoop();
	return 0;
}









