// Code is GPL
// created by akbar A.
// contact: syedali011@earthlink.net

#include <GL/glut.h>
#include <stdio.h>
#include <malloc.h>	// stupid warning
#include <math.h>
#include "util.h"
#include "type.h"
#include "func.h"
#include "raybox.h"



struct box *b_test;	// box test
vec3f ray_start;
vec3f ray_dir;
vec3f rtmp;		// ray end point 
float t = 1;	// scalar variable to multiple by
int line_thick = 7;

int win_width = 640;
int win_height = 480;
int ray_repos = FALSE; // reposition ray
int console_init = FALSE;

// hackish naming ;-)
// this can be converted into 3d. the algorithm *IS*/*Designed* for 3d boxes,
typedef enum {TOP_LINE, BOT_LINE, LEFT_LINE, RIGHT_LINE};


int manip = FALSE;
int manip_line = -1;
int prev_x, prev_y;
int pos[2];




void enableAA()
{
	GLfloat values[2];
	
	glGetFloatv(GL_LINE_WIDTH_GRANULARITY, values);
	glGetFloatv(GL_LINE_WIDTH_RANGE, values);
	
	if(values[1] < line_thick)
		line_thick = values[1];
	
	
	
	
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
}


void init(void)
{
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glShadeModel(GL_SMOOTH);
	init_box();
	init_ray();
	enableAA();
	
}


struct box *malloc_box()
{
	struct box *tmp;
	tmp = (struct box *)malloc(sizeof(struct box));
	return tmp;
}


void help_dump()
{
	printf("see menu ala' right click;)\n");
	printf("if your to lazy {w,s,a,d} will modify the planes\n");

	printf("for the input routines, are *not* robust. They will break if you try to be clever\n");
	printf("only numbers like 1.234, etc..\n");
	
	
	
}



void keyboard(unsigned char key, int x, int y)
{
    switch(key)	{
	case 'h':
		help_dump();
		break;
	case 'w':
		manip_line = TOP_LINE;
		break;
	case 'd':
		manip_line = BOT_LINE;
		break;
	case 'a':
		manip_line = LEFT_LINE;
		break;
	case 's':
		manip_line = RIGHT_LINE;
		break;
		
	default:
		break;
	}
	
}





void
motion(int x, int y)
{
	int ax, ay;
	
	
	
	ay = prev_y - y;
	ax = prev_x - x;
	
	if(prev_x == x)
		ax = 0;
	if(prev_y == y)
		ay = 0;
	
	
	switch(manip_line)	{
	case BOT_LINE:
		b_test->min[1] += (float)ay/ 25;
		break;
	case TOP_LINE:
		b_test->max[1] += (float) ay/25;
		break;
	case LEFT_LINE:
		b_test->min[0] -= (float) ax/25;		// hackish subtract {it works :) }
		break;
		
	case RIGHT_LINE:
		b_test->max[0] -= (float) ax/25;
		break;
		
		
		
	default:
		break;
	}
	
	
	
	prev_x = x;
	prev_y = y;
	glutPostRedisplay();
	
}





void
mouse(int button, int state, int x, int y)
{
	
	prev_x = x;
	prev_y = y;
	
	
}




int rt;	// return value for intersection

void idle(void)
{
	t = 1;
}



void run_ray_intersect()
{
	int i = 0;
	
	vec3f cord_hit;
	
	CPYV(rtmp, ray_dir);
	
	for(t; t < 15; t += 0.25)	{
		
		rt = hit_bound_box(b_test->min, b_test->max, ray_start /* origin*/, 
			rtmp, cord_hit);
		if(rt == TRUE)	{
			glColor3f(1.0,0.0, 0.0);

			
/*
			if( (cord_hit[0] <= 0) || (cord_hit[1] <= 0))	{
				glColor3f(1.0, 1.0, 0.0);
							
				CPYV(cord_hit, ray_start);
			}
*/			
				output(34, 34, "Collision at { X = %f; Y = %f; Z = %f }", cord_hit[0],
				cord_hit[1], cord_hit[2]);
			draw_ray(cord_hit);
			
						
			
			break;
		}

		if(rt == 2)	{
				output((win_width)/1.60, 34, "start point is inside box.");	
				break;
		
		}


		if(rt == FALSE)
		output(34, 34, "No Intersection");
		
		
			
		else 
			printf("The box is not a box");
		
		
		
		
		glutPostRedisplay();
		
	}
	
}


void init_ray()
{
	SETD(ray_start, -1.0, 0.50, 0.0);
	SETD(ray_dir, 0.50, 1.0, 0.0);
	CPYV(rtmp, ray_dir);
}

void init_box()
{
	b_test = malloc_box();
	
	SETD(b_test->min, 5.0, 10.0, 0.0);
	SETD(b_test->max, 15.0, 25.0, 0.0);
}


void triangle(void)
{
	
	glBegin(GL_QUADS);
	glColor3f(1.0, 0.0, 0.0);
	//glVertex3f(5.0, 10.00, 0.0);
	glVertex3fv(b_test->min);
	
	glColor3f(0.0, 1.0, 0.0);
	//glVertex3f(15.0, 10.0, 0.0);
	glVertex3f(b_test->max[0], b_test->min[1], 0.0);
	glColor3f(0.0, 0.0, 1.0);
	//glVertex3f(15.0, 25.0, 0.0);
	glVertex3f(b_test->max[0], b_test->max[1], 0.0);
	glColor3f(1.0, 1.0, 0.0);
	//glVertex3f(5.0, 25.0, 0.0);
	glVertex3f(b_test->min[0], b_test->max[1], 0.0);
	glEnd();
	
}



void draw_ray(vec3f hit_point)
{
	
	glColor3f(1.0, 1.0, 0.0);
	glLineWidth(line_thick);
	glBegin(GL_LINES);
	glVertex3fv(ray_start);
	glVertex3fv(hit_point);
	glEnd();
	
	
}

void dump_cord_data()
{
	glColor3f(1.0, 0.0, 0.0);
	output((win_width/3) ,(win_height/1.05), "ray start = %f %f %f", ray_start[0], ray_start[1], ray_start[2]);
	output((win_width/3) ,(win_height/1.05) -30, "ray dir = %f %f %f", ray_dir[0], ray_dir[1], ray_dir[2]);
	
}



void display(void)
{
	
	glClear(GL_COLOR_BUFFER_BIT);
	triangle();
	run_ray_intersect();
	dump_cord_data();
	draw_about();
	
	
	
	if(rt != TRUE)	{		
		glColor3f(1.0, 1.0, 0.0);
		output(34, 34, "No Intersection");		
	}
	
	
	glutSwapBuffers();	
	glFlush();
}

void reshape(int w, int h)
{
	glViewport(0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	win_width = w;
	win_height = h;
	
	
	if(w <= h)
		gluOrtho2D(0.0, 30.0, 0.0, 30.0*(GLfloat)h/(GLfloat)w);
	else
		gluOrtho2D(0.0, 30.0*(GLfloat)w/(GLfloat)h, 0.0, 30.0);
	glMatrixMode(GL_MODELVIEW);
}



void repos_ray()
{
	
}



// although this is 2d demo, you can add in a 3rd dimentions
// move it to perspective and you will have 3d box collisions	
void get_input()
{
	printf("ray data- config\n");
	printf("in the parenthess i give you 'safe' values\n");
	printf("if you can't seem to hit a collision, it might because of your\ndirection. mess with the box values\n");
	
	printf("*** Start position \n");
	
	printf("x(0 - 35) = ");
	scanf("%f",   &ray_start[0]);
	
	printf("y(0 -25) = ");
	scanf("%f", &ray_start[1]);
	
}


void normalize(float *ray, int dim)
{
	float len;
	float tmp[2];

	if(dim == 2)	{
		tmp[0] = (ray[0]*ray[0]);
		tmp[1] = (ray[1] *ray[1]);
		len = sqrt( tmp[0] + tmp[1]);
	}

	else
		printf("3 dim norm not coded in\n");

	ray[0] /= len;
	ray[1] /= len;
}





void change_ray_dir()
{

	printf("this data should be entered in unit circle cordinates [-1,1]\n");
	printf("if i not, i normalize them ;-)\n");
	printf("please enter direction coords\n");
	
	// HACK
	printf("x = ");	scanf("%f", &ray_dir[0]);
	printf("y = "); scanf("%f", &ray_dir[1]);

	// check for [-1,1]
	if( (ray_dir[0] > 1 || ray_dir[0] < -1)  || ( ray_dir[1] < -1 ||  ray_dir[1] > 1) )	{
		normalize(ray_dir, 2);
		printf("after normalize = %f %f\n", ray_dir[0], ray_dir[1]);
	}




	printf("coords are %f %f\n", ray_dir[0], ray_dir[1]);
	glutPostRedisplay();
	
}




int show_about = FALSE;

void draw_about()
{
	glColor3f(0.0, 1.0, 0.0);
	if(show_about == TRUE)
		output(34, 34+20 , "ray-box collision demo by akbar A.");
}


void
menu(int value)
{
	//  //manip_line = BOT_LINE;
	//manip_line = RIGHT_LINE;
	
	switch (value) {
	case 'h':
		help_dump();
		break;
	case 'w':
		manip_line = TOP_LINE;
		break;
	case 'a':
		manip_line = LEFT_LINE;
		break;
	case 's':
		manip_line = RIGHT_LINE;
		break;
	case 'd':
		manip_line = BOT_LINE;
		break;
	case 'r':
		change_ray_dir();
		break;
	case 'p':
		ray_repos = !ray_repos;
		if(ray_repos == TRUE)
			get_input();
		
		break;
	case 'm':
		show_about = !show_about;		
		break;
		
	default:
		break;
	}
	
	glutPostRedisplay();
}









int main(int argc, char **argv)
{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
	glutInitWindowSize(win_width, win_height);
	glutInitWindowPosition(500, 500);
	glutCreateWindow("ray-box collision");
	init();
	glutDisplayFunc(display);
	glutMotionFunc(motion);
	glutKeyboardFunc(keyboard);
	glutMouseFunc(mouse);
	glutReshapeFunc(reshape);
	glutIdleFunc(idle);
	
	glutCreateMenu(menu);
	glutAddMenuEntry("modify top plane", 'w');
	glutAddMenuEntry("modify bottom plane", 'd');
	glutAddMenuEntry("modify left plane", 'a');
	glutAddMenuEntry("modify right plane", 's');
	
	
	glutAddMenuEntry("-------------------", ' ');
	glutAddMenuEntry("change ray starting point", 'p');
	glutAddMenuEntry("change direction of ray", 'r');
	glutAddMenuEntry("-------------------", ' ');
	glutAddMenuEntry("about", 'm');
	
	
	glutAddMenuEntry("Help", 'h');
	glutAttachMenu(GLUT_RIGHT_BUTTON);
	
	glutMainLoop();
	return 0;
	
}

