#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

extern int win_width;
extern int win_height;


void
output(int x, int y, char *format,...)
{
	va_list args;
	char buffer[200], *p;
	int w, h;
	w = win_width;
	h = win_height;
	
	// FIXME: check if gl_lighting is enabled
	// if using the gl light code
	// ditto for the blend modes
	glDisable(GL_LIGHTING);
	
	
	
	
	
	
	
	va_start(args, format);
	vsprintf(buffer, format, args);
	va_end(args);
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, w, 0, h);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	
	
	
	
	glPushMatrix();
	
	glRasterPos2f(x, y);
	for (p = buffer; *p; p++)
		glutBitmapCharacter(GLUT_BITMAP_9_BY_15, *p);
	
	glPopMatrix();
	
	
	glDisable(GL_LINE_SMOOTH);
	glDisable(GL_BLEND);
	
	glPopMatrix();
	
	
	
	
	glViewport(0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	if(w <= h)
		gluOrtho2D(0.0, 30.0, 0.0, 30.0*(GLfloat)h/(GLfloat)w);
	else
		gluOrtho2D(0.0, 30.0*(GLfloat)w/(GLfloat)h, 0.0, 30.0);
	glMatrixMode(GL_MODELVIEW);
		
	
}