
/* gli_misc.c - OpenGL image (GLI) file loader */

/* Copyright NVIDIA Corporation, 1999. */

/* $Id: //sw/main/apps/OpenGL/mjk/md2shader/gli_misc.c#3 $ */

/* Miscellaneous routines for lightweight generic image
   file loader for OpenGL programs. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Include stuff that should be in <GL/gl.h> that might not be in your version. */

#include "gli.h"
#include "gli_internal.h"

char __gliError[256];
unsigned int __gliVerbose = 0;

int
gliHasAlpha(gliGenericImage *image)
{
  return (image->format == GL_RGBA) || (image->format == GL_LUMINANCE_ALPHA);
}

gliGenericImage *
gliDepalette(gliGenericImage *image)
{
  gliGenericImage *newImage;
  int i, j, c;
  int w, h, entries;
  int components;
  GLubyte *newPixels, *pixels, *cmap;

  if (image->cmap == NULL) {
    return NULL;
  }

  if ((image->cmapFormat == GL_BGR_EXT) || (image->cmapFormat == GL_RGB)) {
    components = 3;
  } else if ((image->cmapFormat == GL_BGRA_EXT) ||
             (image->cmapFormat == GL_ABGR_EXT) ||
             (image->cmapFormat == GL_RGBA)) {
    components = 4;
  } else {
    return NULL;
  }

  w = image->width;
  h = image->height;
  pixels = image->pixels;
  cmap = image->cmap;
  entries = image->cmapEntries;

  newPixels = (GLubyte*) malloc(w * h * components);
  for (j=0; j<h; j++) {
    for (i=0; i<w; i++) {
      for (c=0; c<components; c++) {
        newPixels[(j*w+i)*components+c] = cmap[pixels[j*w+i]*components+c % entries];
      }
    }
  }

  newImage = (gliGenericImage*) malloc(sizeof(gliGenericImage));
  newImage->width = w;
  newImage->height = h;
  newImage->format = image->cmapFormat;
  newImage->components = components;
  newImage->cmapEntries = 0;
  newImage->cmapFormat = GL_NONE;
  newImage->cmap = NULL;
  newImage->pixels = newPixels;

  return newImage;
}

void
gliFree(gliGenericImage *image)
{
  if (image->pixels) {
    free(image->pixels);
  }
  if (image->cmap) {
    free(image->cmap);
  }
  free(image);
}

int
gliVerbose(int newVerbose)
{
  int oldVerbose = __gliVerbose;
  __gliVerbose = newVerbose;
  return __gliVerbose;
}

char *
gliGetLastError(void)
{
  return __gliError;
}
