#ifndef __gli_h__
#define __gli_h__

/* gli.h - OpenGL image (GLI) file loader */

/* Copyright NVIDIA Corporation, 1999. */

/* $Id: //sw/main/apps/OpenGL/mjk/md2shader/gli.h#3 $ */

/* A lightweight generic image file loader for OpenGL programs. */

#include <stdio.h>
#include <GL/glut.h>

/* EXT_bgra defines from <GL/gl.h> */
#ifndef GL_EXT_bgra
#define GL_BGR_EXT                          0x80E0
#define GL_BGRA_EXT                         0x80E1
#endif

/* EXT_abgr defines from <GL/gl.h> */
#ifndef GL_ABGR_EXT
#define GL_ABGR_EXT                       0x8000
#endif

typedef struct {

  GLsizei  width;
  GLsizei  height;
  GLint    components;
  GLenum   format;

  GLsizei  cmapEntries;
  GLenum   cmapFormat;
  GLubyte *cmap;

  GLubyte *pixels;
  
} gliGenericImage;

extern gliGenericImage *gliReadPCX(FILE *fp, char *name, int yFlip);
extern gliGenericImage *gliReadTGA(FILE *fp, char *name, int yFlip);
extern int gliVerbose(int newVerbose);
extern gliGenericImage *gliDepalette(gliGenericImage *image);
extern int gliMergeAlpha(gliGenericImage *image, gliGenericImage *alpha);
extern void gliFree(gliGenericImage *image);
extern char *gliGetLastError(void);
extern int gliHasAlpha(gliGenericImage *image);

#endif /* __gli_h__ */
