#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>
#include "types.h"




struct ndata	{
	vec3f norm;
};


struct ndata *g_norm;


// contains *all* the rendering {vertices, normal, index} buff
// for teh draw loop
struct d_data *v_data;	// per vertex
struct face *face_list;
struct t_list *txt_list;		// texture list
int max_vert;
int v_pos = 0;
int m_pos = 0;
int f_pos = 0;
int max_faces;
int l_mvertexnorm = 0;	// hackish?
int vn_tracker;


	

int m_numverts;
int m_numfaces;
int m_numtexfaces;
int m_numtexverts;
unsigned int *m_faces;
unsigned int *m_texfaces;
float m_texutile;
float m_texvtile;
float m_texUoffset;
float m_textVoffset;


struct d_data *alloc_data(int size)
{
	struct d_data *dat;
	dat = (struct d_data *)malloc(sizeof(struct d_data)
		* size);

	if(dat == NULL)	{
		printf("error in d_data *alloc_data() function\n");
		exit(1);
	}
	return dat;
}



struct t_list *alloc_tlist(int size)
{
	struct t_list *tmp;
	tmp = (struct t_list *)malloc(sizeof(struct t_list) * size);
	return tmp;
}


struct face *alloc_flist(int size)
{
	struct face *tmp;
	tmp = (struct face *)malloc(sizeof(struct face)*size);
	return tmp;
}


void alloc_numf(int size)
{
	face_list = alloc_flist(size);
	g_norm = (struct ndata *)malloc(sizeof(struct ndata)*size);

}

void alloc_numtv(int size)
{
	txt_list = alloc_tlist(size);
}



void free_data(struct d_data *dat)
{
	free(dat);
}

void get_vertex(FILE *fp)
{
	int i = 0;
	fscanf(fp, "%i", &i);

	// FIXME: update 2 trackers?
	v_pos = i;
	v_data[i].index = i;

	fscanf(fp, "%f %f %f", &v_data[i].vertex[0], &v_data[i].vertex[1],
		&v_data[i].vertex[2]);
	
//	v_data[i].vertex[2] = -v_data[i].vertex[2];

}


void dump_info()
{
	FILE *fp;
	int i = 0;
	printf("************ vertex dump *********\n");
	fp = fopen("dump.txt", "w+");
	if(fp == NULL)
		printf("PROBLEM\n");


	fprintf(fp, "HEEEEEEEEELLLLO\n");
	fprintf(fp, "-----MAX_FACES = %i\n", max_faces);
	printf("v_pos = %i\n", v_pos);
	for(i; i < v_pos; i++)	{
		fprintf(fp, "vertex pos = %i\n X=%f\n	\
			Y=%f\n	Z=%f\n", i, 
		v_data[i].vertex[0], v_data[i].vertex[1],
		v_data[i].vertex[2]);
	
	}


	fclose(fp);
}







void get_face(FILE *fp)
{
	int i;
	fscanf(fp, "%i:", &i);
	
	fscanf(fp, "\tA:\t%d B:\t%d C:\t%d", &face_list[i].seq[0], 
		&face_list[i].seq[1], &face_list[i].seq[2]);

}


void
vcopy(const float *v1, float *v2)
{
    register int i;
    for (i = 0 ; i < 3 ; i++)
        v2[i] = v1[i];
}

void
vcross(const float *v1, const float *v2, float *cross)
{
    float temp[3];

    temp[0] = (v1[1] * v2[2]) - (v1[2] * v2[1]);
    temp[1] = (v1[2] * v2[0]) - (v1[0] * v2[2]);
    temp[2] = (v1[0] * v2[1]) - (v1[1] * v2[0]);
    vcopy(temp, cross);
}



void r_model()
{
	int i = 0;
	//vec3f v1,v2,v3;
	int pos[3];
	int norm_track[3];
	vec3f tmp;
	vec3f vnorm;
	int itmp;
	static int red_mode = 1;

	static int theta = 1;
	theta += 0.25;
	if(theta > 10.0)
		theta = 0.50;



	glColor3f(1.00000f, 1.00000f, 1.00000f);
	for(i; i < max_faces; i++)	{
		glBegin(GL_TRIANGLES);
//		glNormal3fv(face_list[i].f_norm);
		pos[0] = face_list[i].seq[0];
		pos[1] = face_list[i].seq[1];
		pos[2] = face_list[i].seq[2];
		

		//face_list[f_pos].vnorm_seq[tmp]
		


		norm_track[0] = face_list[i].v_norm[0];
		norm_track[1] = face_list[i].v_norm[1];
		norm_track[2] = face_list[i].v_norm[2];

		// FIXME:!
		norm_track[2] = face_list[i].v_norm[2] = 0.0;

		//face_list[f_pos].vnorm_seq[it]


//		itmp = face_list[i].vnorm_seq[0];
		//face_list[f_pos].vnorm_seq[tmp]

		glNormal3fv(v_data[face_list[i].vnorm_seq[0]].normal);
		
		if(red_mode)
			glColor3f(0.00, 0.0, 1.0);
		else if(red_mode == 0)
			glColor3f(1.0, 1.0, 0.0);
		else
			glColor3f(0.0, 0.0, 1.0);

		glVertex3fv(v_data[pos[0]].vertex);
	
		glNormal3fv(v_data[face_list[i].vnorm_seq[1]].normal);
		
		if(red_mode)
			glColor3f(0.00, 1.0, 0.0);
		else if(red_mode == 0)
			glColor3f(1.0, 1.0, 0.0);
		else
			glColor3f(0.0, 0.0, 1.0);

		glVertex3fv(v_data[pos[1]].vertex);

		glNormal3fv(v_data[face_list[i].vnorm_seq[2]].normal);
		if(red_mode)
			glColor3f(0.00, 0.0, 1.0);
		else if(red_mode == 0)
			glColor3f(1.0, 1.0, 0.0);
		else
			glColor3f(0.0, 0.0, 1.0);

		glVertex3fv(v_data[pos[2]].vertex);
		red_mode --;
		if(red_mode < -2)
			red_mode = 1;
		
	}

}




void get_tvertex(FILE *fp)
{
	int i;
	fscanf(fp, "%i", &i);
	fscanf(fp, "%f %f", &v_data[i].txt_cord[0], 
		v_data[i].txt_cord[1]);

}

void get_tface(FILE *fp)
{
	int i;
	fscanf(fp, "%i", &i);
	fscanf(fp, "%i %i %i", &txt_list[i].seq[0],
		&txt_list[i].seq[1], &txt_list[i].seq[2]);

}


void get_uoffset(FILE *fp)
{
	float u;
	int i;
	i = v_data->index;	

	fscanf(fp, "%f", &u);
	v_data[i].txt_cord[0] += u;

}


void get_voffset(FILE *fp)
{
	float v;
	int i;
	i = v_data->index;

	fscanf(fp, "%f", &v);
	v_data[i].txt_cord[1] += v;
}


void alloc_numv(int i)
{
	v_data = alloc_data(i);
}




void get_fnormals(FILE *fp)
{
	float lf_norm[3];	// l for local naming convention?
	float v_norm[3];
	int i = 0;
	int tmp = 0;
	int pos = 0;

	fscanf(fp, "%i %f %f %f",
		&i, &lf_norm[0], &lf_norm[1], &lf_norm[2]);

	// TODO: put this in the allocate bloco on the max
	// this should light the scene fine
	face_list[i].f_norm[0] = lf_norm[0];
	face_list[i].f_norm[1] = lf_norm[1];
	face_list[i].f_norm[2] = lf_norm[2];
	f_pos = i;

	
}

void dump_norm()
{
	FILE *fp;
	int i =0;
	fp = fopen("norm.txt", "w+");
	if(fp == NULL)	{
		printf("error in dump_norm()\n");
		exit(1);
	}

	printf("****** face data *********\n");
	
	for(i; i < max_faces; i++)	{
		fprintf(fp, "face num=%i\nX Comp = %f\tY Comp = %f\tZ Comp %f\n\n",
			i,
			face_list[i].f_norm[0],	
			face_list[i].f_norm[1], 
			face_list[i].f_norm[2]);
	}

	fclose(fp);
}

		


static int it = 0;
static int tk = 0;
static int safe_keep = 0;

void trans_data(vec3f *dat, vec3f *crap)
{
	float tmp;
	memcpy(dat, crap, sizeof(vec3f));
}


static int vnorm_track = 0;

void get_vnormals(FILE *fp)
{
	int pos = 0;	// FIXME
	int tmp;
	int a;
		
/*	if(f_pos == 203)
		return -1;
		*/
	
	
	
	fscanf(fp, "%i",&pos);

	
	fscanf(fp, "%f %f %f", 	&v_data[pos].normal[0], 
		&v_data[pos].normal[1], &v_data[pos].normal[2]);

	tmp = vnorm_track;

	
	face_list[f_pos].vnorm_seq[tmp] = pos;

	vnorm_track++;
	
	if(vnorm_track >= 3)
		vnorm_track = 0;





	

}

void dump_vnormal()
{
	FILE *fp;
	int i = 0;
	fp = fopen("vnorml.txt", "w+");

	for(i; i < max_vert; i++)
		fprintf(fp, "position = %i\t x = %f\t y = %f\t z = %f\n",
		i, v_data[i].normal[0], v_data[i].normal[1],
		v_data[i].normal[2]);
}







void get_mfaces(FILE *fp)
{
	fscanf(fp, "%i",
		&max_faces);
}


void get_mvert(FILE *fp)
{
	fscanf(fp, "%i", &max_vert);
}

void get_ase_data(FILE *fp)
{
	char buff[256];
	rewind(fp);

	while(!feof(fp))	
	{
		fscanf(fp, "%s", &buff);

		
		// works only with one mesh :(
		// have to merge them if you want more then one object in
		// scene
		if( strcmp(buff, "*MESH_NUMVERTEX") == 0)	{
			get_mvert(fp);
			alloc_numv(max_vert);
		}

		else if( strcmp(buff, "*MESH_NUMFACES") == 0)	{
			get_mfaces(fp);			
			alloc_numf(max_faces);
		}

		else if( strcmp(buff, "*MESH_VERTEX") == 0)	{
			get_vertex(fp);
		}

		else if( strcmp(buff, "*MESH_FACE") == 0)	{
			get_face(fp);
		}

		else if( strcmp(buff, "*MESH_NUMTVERTEX") == 0)	{
			alloc_numtv(atoi(buff));
			get_tvertex(fp);
		}

		else if( strcmp(buff, "*MESH_TFACE") == 0)	{
			get_tface(fp);
		}

		else if( strcmp(buff, "*UVW_U_OFFSET") == 0)
			get_uoffset(fp);
		else if( strcmp(buff, "*UVW_V_OFFSET") == 0)
			get_voffset(fp);
		else if( strcmp(buff, "*MESH_FACENORMAL") ==0)	{			
			get_fnormals(fp);
		}
		else if( strcmp(buff, "*MESH_VERTEXNORMAL") == 0)	{
			get_vnormals(fp);
		}





		else fgets(buff, 256, fp);
	}
}


void load_ase_file(char *name)
{
	FILE *fp;
	int max_vert = 0;
	fp = fopen(name, "r");

	if(fp == NULL)	{
		printf("File not there or something ;|\n");
		exit(1);
	}
	get_ase_data(fp);
	fclose(fp);



}









