#pragma check_stack(off)
#pragma comment(linker,"/OPT:NOWIN98")
#include "windows.h"
#include <string>
#include <vector>
#include <fstream>
//if (GetFileAttributes ("myfile.txt") == 0xFFFFFFFF) { /* doesn't exist */ }
inline void MB(char*message) { MessageBox(NULL,message,"Message",MB_OK); }

typedef struct {
    DWORD  mVersion;
    HWND   mHwnd;
    BOOL   mKeep;
} LOADINFO;

struct ItemInfo {
	HICON icon;
	HICON rollover;
	char*text;
	char*cmd;
	char*id;
	char menuchar;
	HMENU submenu;
	bool bold;
};

HANDLE hFileMap;
LPSTR mData;
HWND pophwnd;
HINSTANCE hInst;
HFONT menuFont, menuBFont;
std::vector<ItemInfo> PopreadMenuItems;
HMENU popreadmenu;

char*gettok(const char *s, long tok_num, char *d, long*num_tok, long*next_tok);
long pos(const char *stringin,const char *str,long occurence,long offset,long numocc);
void onDrawItem(DRAWITEMSTRUCT* dItem);
void onMeasureItem(MEASUREITEMSTRUCT* mItem);
void DrawLine(HDC hDC,int fromX, int fromY, int toX, int toY);
void charreplace(char*str,char from,char to);
void chartrimtrailing(char*str,char*trimchar);
void chartrimleading(char*str,char*trimchar);

UINT NoNegativeNumbers(int number);
LRESULT CALLBACK WindowProc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam);

//make sure we get out HINSTANCE so we can make our window
int WINAPI DllMain(HINSTANCE hInstance,DWORD dwREason,LPVOID Reserved) {
	hInst = hInstance;
	return 1;
}
int WINAPI _DllMainCRTStartup(HANDLE hInstance, DWORD, void*) { 
	hInst = (HINSTANCE)hInstance;
	return 1;
}
//begin code
LRESULT CALLBACK WindowProc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam) {
	switch (uMsg)
	{
		case WM_MEASUREITEM:
			onMeasureItem((MEASUREITEMSTRUCT*)lParam);
			return TRUE;
		case WM_DRAWITEM:
			onDrawItem((DRAWITEMSTRUCT*)lParam);
			return TRUE;
		case WM_MENUCHAR:
			HMENU curmenu = (HMENU) lParam;
			UINT flags = (UINT) HIWORD(wParam);
			char mychar = (char) LOWORD(wParam);
			mychar = (char)CharLower((char*)mychar);
			char tempchar;
			int count = GetMenuItemCount(curmenu);
			UINT id;
			int selected = -1;
			int highlight = -1;
			char multiple = 0;
			bool occur = false;
			for (int curItem = 0;curItem < count;curItem++) {
				MENUITEMINFO menuItem;
				menuItem.cbSize = sizeof(MENUITEMINFO);
				menuItem.fMask = MIIM_DATA | MIIM_STATE;
				GetMenuItemInfo(curmenu,curItem,true,&menuItem);
				id = atoi((char*)menuItem.dwItemData) - 1;
				tempchar = PopreadMenuItems[id].menuchar;
				tempchar = (char)CharLower((char*)tempchar);
				if (tempchar == mychar) {
					occur = true;
				}
				if ((menuItem.fState & MFS_HILITE) && (occur))
					highlight = curItem;
				if (tempchar == mychar) {
					if (selected == -1)
							selected = curItem;
					else {
						multiple = 1;
						if ((curItem > highlight) && (highlight != -1))
							return MAKELRESULT(curItem ,MNC_SELECT);
					}
				}
			}
			if (selected == -1)
				return MAKELRESULT(0,MNC_IGNORE);
			if (multiple)
				return MAKELRESULT(selected,MNC_SELECT);
			return MAKELRESULT(selected,MNC_EXECUTE);
	}
	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}
void onMeasureItem(MEASUREITEMSTRUCT* mItem) {
	HDC TempDC = CreateCompatibleDC(NULL);
	UINT id = atoi((char*)mItem->itemData);
	ItemInfo popinfo = PopreadMenuItems[id - 1];
	char*mycharthing = new char[2];
	mycharthing[1] = '\0';
	mycharthing[0] = (char)2;
	if (pos(popinfo.text,mycharthing,1,0,0) != -1) {
		charreplace(popinfo.text,mycharthing[0],'\0');
		DeleteObject(SelectObject(TempDC, menuBFont));
		PopreadMenuItems[id - 1].bold = true;
	}
	else {
		DeleteObject(SelectObject(TempDC, menuFont));
		PopreadMenuItems[id - 1].bold = false;
	}
	delete[] mycharthing;
	RECT myrect;
//	SIZE txtSize;
//	UINT id = atoi((char*)mItem->itemData);
//	ItemInfo popinfo = PopreadMenuItems[id - 1];
	if (popinfo.submenu) {
		if (GetMenuItemCount(popinfo.submenu) == 0) {
			EnableMenuItem(popreadmenu,(UINT)popinfo.submenu,MF_BYCOMMAND | MF_GRAYED);
		}
	}
	DrawText(TempDC,popinfo.text,-1,&myrect,DT_SINGLELINE | DT_EXPANDTABS | DT_CALCRECT);
//	GetTextExtentPoint32(TempDC, popinfo.text, lstrlen(popinfo.text) + 1, &txtSize);
//	mItem->itemWidth = txtSize.cx + 20;
//	mItem->itemHeight = txtSize.cy + 5;
	mItem->itemWidth = myrect.right - myrect.left + 31; //21
	mItem->itemHeight = myrect.bottom - myrect.top + 5;
	DeleteDC(TempDC);
}
void onDrawItem(DRAWITEMSTRUCT* dItem) {
	HDC TempDC = CreateCompatibleDC(NULL);
	HDC hScreen = CreateDC("DISPLAY", NULL, NULL, NULL);
	DeleteObject(SelectObject(TempDC, CreateCompatibleBitmap(hScreen, dItem->rcItem.right - dItem->rcItem.left, dItem->rcItem.bottom - dItem->rcItem.top)));
	DeleteDC(hScreen);
	HGDIOBJ OldFont;

	UINT id = atoi((char*)dItem->itemData);
	ItemInfo popinfo = PopreadMenuItems[id - 1];

	if (popinfo.bold) {
		OldFont = SelectObject(TempDC, menuBFont);
	}
	else {
		OldFont = SelectObject(TempDC, menuFont);
	}

	COLORREF menutext;
	COLORREF back;
	HPEN checkpen;

	if (dItem->itemState & ODS_SELECTED) {
		menutext = (COLORREF)GetSysColor(COLOR_HIGHLIGHTTEXT);
		back = (COLORREF)GetSysColor(COLOR_HIGHLIGHT);
	}
	else {
		menutext = (COLORREF)GetSysColor(COLOR_MENUTEXT);
		back = (COLORREF)GetSysColor(COLOR_MENU);
	}
	BOOL disabled = false;
	if (dItem->itemState & ODS_GRAYED) {
		disabled = true;
		menutext = (COLORREF)GetSysColor(COLOR_GRAYTEXT);
//		back = (COLORREF)GetSysColor(COLOR_MENU);
	}
	COLORREF oldtext = SetTextColor(TempDC,menutext);
	RECT myrect = dItem->rcItem;
	myrect.left = 0;
	myrect.right = myrect.right - myrect.left;
	myrect.bottom = myrect.bottom - myrect.top;
	myrect.top = 0;
	COLORREF oldbk = SetBkColor(TempDC,back);
	HPEN hPen = (HPEN)SelectObject (TempDC, CreatePen(PS_SOLID,0,back));
	HBRUSH hBrush = (HBRUSH)SelectObject (TempDC, CreateSolidBrush(back));
	Rectangle(TempDC,myrect.left, myrect.top,myrect.right + 1, myrect.bottom);
	myrect.left = 23; //24
	myrect.right = myrect.right - 2;
	DrawText(TempDC,popinfo.text,-1,&myrect,DT_SINGLELINE | DT_EXPANDTABS | DT_LEFT | DT_VCENTER);
	SelectObject(TempDC, OldFont);
	myrect.left = 1;
	myrect.top = myrect.top + ((myrect.bottom - myrect.top - 16) / 2);
	if (dItem->itemState & ODS_CHECKED) {
		checkpen = (HPEN)SelectObject (TempDC, CreatePen(PS_SOLID,0,menutext));
		DrawLine(TempDC,myrect.left + 7,myrect.top + 12,myrect.left + 12,myrect.top + 7);
		DrawLine(TempDC,myrect.left + 7,myrect.top + 11,myrect.left + 12,myrect.top + 6);
		DrawLine(TempDC,myrect.left + 6,myrect.top + 11,myrect.left + 12,myrect.top + 5);
		DrawLine(TempDC,myrect.left + 6,myrect.top + 10,myrect.left + 6,myrect.top + 8);
		DrawLine(TempDC,myrect.left + 5,myrect.top + 10,myrect.left + 5,myrect.top + 7);
		DeleteObject (SelectObject (TempDC, checkpen));
	}
	else {
		if (dItem->itemState & ODS_SELECTED) {
			if (popinfo.rollover) {
				if (disabled) {
					DrawState(TempDC, 0, 0, reinterpret_cast<LPARAM>(popinfo.rollover), NULL, myrect.left,myrect.top, 16, 16, DST_ICON | DSS_DISABLED);
				}
				else {
					DrawIconEx(TempDC,myrect.left,myrect.top,popinfo.rollover,16,16,0,NULL,DI_NORMAL);
				}
			}
		}
		else {
			if (popinfo.icon) {
				if (disabled) {
					DrawState(TempDC, 0, 0, reinterpret_cast<LPARAM>(popinfo.icon), NULL, myrect.left,myrect.top, 16, 16, DST_ICON | DSS_DISABLED);
				}
				else {
					DrawIconEx(TempDC,myrect.left,myrect.top,popinfo.icon,16,16,0,NULL,DI_NORMAL);
				}
			}
		}
	}
	BitBlt(dItem->hDC,dItem->rcItem.left,dItem->rcItem.top,dItem->rcItem.right - dItem->rcItem.left,dItem->rcItem.bottom - dItem->rcItem.top,TempDC,0,0,SRCCOPY);
	DeleteObject (SelectObject (TempDC, hPen));
	DeleteObject (SelectObject (TempDC, hBrush)) ;
	SetTextColor(TempDC,oldtext);
	SetBkColor(TempDC,oldbk);
	DeleteDC(TempDC);
}
void DrawLine(HDC hDC,int fromX, int fromY, int toX, int toY) {
	POINT oldcoords;
	MoveToEx(hDC,fromX,fromY,&oldcoords);
	LineTo(hDC,toX,toY);
	MoveToEx(hDC,oldcoords.x,oldcoords.y,NULL);
}
int WINAPI UnloadDll(int timeout)
{
	if (!timeout)
	{
		UnmapViewOfFile(mData);
		CloseHandle(hFileMap);
		DestroyWindow(pophwnd);
	}
	return 0;
}
LPSTR call_alias(HWND mWnd, int ident, const char *data)
{
	if (ident == 0) {
	wsprintf(mData,"//var %s",data);
	SendMessage(mWnd,WM_USER + 201,0,0);
	CopyMemory(mData, mData + 5, lstrlen(mData) - 4);
    return mData;
	} else {
	wsprintf(mData,"%s",data);
	SendMessage(mWnd,WM_USER + 200,0,0);
    return mData;
	}
}
void WINAPI LoadDll(void*)
{
	hFileMap = CreateFileMapping(INVALID_HANDLE_VALUE,0,PAGE_READWRITE,0,4096,"mIRC");	
	mData = (LPSTR)MapViewOfFile(hFileMap,FILE_MAP_ALL_ACCESS,0,0,0);
	WNDCLASSEX WndClass;
	WndClass.cbSize = sizeof(WndClass);
	WndClass.style = 0;
	WndClass.lpfnWndProc = &WindowProc;
	WndClass.cbClsExtra = 0;
    WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = NULL;
	WndClass.hCursor = NULL;
	WndClass.hbrBackground = NULL;
	WndClass.lpszMenuName = NULL;
	WndClass.lpszClassName = "popreadwindow";
	WndClass.hIconSm = NULL;
	RegisterClassEx(&WndClass);
	pophwnd = CreateWindow("popreadwindow", NULL, 0, 0, 0, 0, 0, NULL, NULL, hInst, NULL);
	NONCLIENTMETRICS ncMetrics;
	ncMetrics.cbSize = sizeof(NONCLIENTMETRICS);
	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICS), &ncMetrics, NULL);
	menuFont = CreateFontIndirect(&ncMetrics.lfMenuFont);
	ncMetrics.lfMenuFont.lfWeight = FW_BOLD;
	menuBFont = CreateFontIndirect(&ncMetrics.lfMenuFont);
}
char*gettok(const char *s, long tok_num, char *d, long*num_tok, long*next_tok) {
	long count, start, end, numtok;
	if (num_tok != NULL) {
		if (*num_tok < 1) {
			numtok = pos(s,d,0,0,0) + 1;
			*num_tok = numtok;
		}
		else {
			numtok = *num_tok;
		}
	}
	else {
		numtok = pos(s,d,0,0,0) + 1;
	}
	bool rev = false;
	if (tok_num == 0) return (char*)numtok;
	char*val;
	if (tok_num < 0) {
		rev = true;
		tok_num = abs(tok_num);
	}
	if (tok_num > numtok || tok_num < 0) {
		val = new char[1];
		val[0] = '\0';
		return val;
	}
	if (tok_num == 1) start = 0;
	else {
		if (next_tok != NULL) {
			if (*next_tok >= 0)
				start = *next_tok;
			else {
				start = pos(s,d,tok_num - 1,0,0) + strlen(d);
				*next_tok = start;
			}
		}
		else {
			start = pos(s,d,tok_num - 1,0,0) + strlen(d);
		}
	}
	if (tok_num == numtok || (rev)) end = strlen(s) - 1;
	else end = pos(s,d,tok_num,start,tok_num - 1) - 1;
	if (next_tok != NULL) {
		if (tok_num == numtok) *next_tok = -1;
		else *next_tok = end + 1 + strlen(d);
	}
	count = 0;
	val = new char[end - start + 2];
	while (start <= end) {
		val[count] = s[start];
		start++;
		count++;
	}
	val[count] = '\0';
	return val;
}
long pos(const char *stringin,const char *str,long occurence,long offset,long numocc)
{
	char *pdest = strstr( stringin + offset, str );
	numocc++;
	long slen = lstrlen(str);
	while ((pdest != NULL) && ((numocc < occurence) || (occurence == 0))) {
		numocc++;
		pdest = strstr(pdest+slen,str);
	}
	if (occurence == 0) return numocc-1;
	if(pdest != NULL) return pdest-stringin;
	return -1;
}
void chartrimleading(char*str,char*trimchar) {
	bool invalid;
	int i;
	long num = 0;
	long valid = 0;
	long slen = strlen(str);
	int tslen = strlen(trimchar);
	char curchar;

	invalid = true;
	while (num < slen) {
		curchar = str[num];
		if (invalid) {
			invalid = false;
			for (i = tslen - 1;i >= 0;i--) {
				if (curchar == trimchar[i]) {
					invalid = true;
					i = -1;
				}
			}
		}
		if (!invalid) {
			if (num != valid) {
				str[valid] = curchar;
			}
			valid++;
		}
		num++;
	}
	str[valid] = '\0';
}
void chartrimtrailing(char*str,char*trimchar) {
	bool match = true;
	long mypos = lstrlen(str) - 1;
	int i;
	long tslen = strlen(trimchar);
	char curchar;
	while ((mypos >= 0) && (match) && lstrlen(trimchar)) {
		match = false;
		curchar = str[mypos];
		for (i = tslen - 1;i >= 0;i--) {
			if (curchar == trimchar[i]) {
				match = true;
				i = -1;
			}
		}
		if (match) {
			mypos--;
		}
		else {
			str[mypos + 1] = '\0';
			mypos = -1;
		}
	}
}
void charreplace(char*str,char from,char to) {
	long len = lstrlen(str);
	long i = 0;
	long valid = 0;
	char curchar;
	bool rem = false;
	if (to == '\0') rem = true;
	while (i < len) {
		curchar = str[i];
		if (curchar == from) {
			if (!rem) {
				str[valid] = to;
				valid++;
			}
		}
		else {
			if (i != valid) {
				str[valid] = curchar;
			}
			valid++;
		}
		i++;
	}
	str[valid] = '\0';
}
int __stdcall mnchk(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL print, BOOL nopause)
{
	int parm;
	HMENU hMenu;
	char*temp;
	if ((long)gettok(data, 0, " ",NULL,NULL) == 1) {
		hMenu = GetMenu(mWnd);
		temp = gettok(data,1," ",NULL,NULL);
		parm = atoi(temp);
	}
	else {
		temp = gettok(data,1," ",NULL,NULL);
		hMenu = (HMENU)atoi(temp);
		delete[] temp;
		temp = gettok(data,2," ",NULL,NULL);
		parm = atoi(temp);
	}
	delete[] temp;
	if (GetMenuState(hMenu,parm,MF_CHECKED) > 0) { wsprintf(data, "%d", 1); return 3; };
	wsprintf(data, "%d", 0);
	return 3;
}
/*int __stdcall testhook(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL print, BOOL nopause)
	{
	WM_MENUSELECT 
	uItem = (UINT) LOWORD(wParam);   // menu item or submenu index 
	fuFlags = (UINT) HIWORD(wParam); // menu flags 
	hmenu = (HMENU) lParam;          // handle to menu clicked 
 
	LoadImage()
	HINSTANCE mhInst = GetWindowLong(mWnd,GWL_HINSTANCE);
	DWORD threadID = GetWindowThreadProcessId(mWnd,NULL);
	SetWindowsHookEx(WH_CALLWNDPROC,&WindowProc,mhInst,threadID);
}*/
int __stdcall mntxt(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL print, BOOL nopause)
{
	int parm;
	HMENU hMenu;
	char*temp;
	if ((long)gettok(data, 0, " ",NULL,NULL) == 1) {
		hMenu = GetMenu(mWnd);
		temp = gettok(data,1," ",NULL,NULL);
		parm = atoi(temp);
	}
	else {
		temp = gettok(data,1," ",NULL,NULL);
		hMenu = (HMENU)atoi(temp);
		delete[] temp;
		temp = gettok(data,2," ",NULL,NULL);
		parm = atoi(temp);
	}
	delete[] temp;
	LPTSTR lpString = "";
	int menustringlen = GetMenuString(hMenu, parm, lpString, 0, MF_BYCOMMAND) + 1;
	GetMenuString(hMenu, parm, lpString, menustringlen, MF_BYCOMMAND);
	wsprintf(data, "%s", lpString);
	return 3;
}
int __stdcall keydown(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL print, BOOL nopause)
{
	if (GetKeyState(atoi(data)) < 0) { 	wsprintf(data, "%d", 1); return 3; } 
	wsprintf(data, "%d", 0);
	return 3;
}
void __stdcall mn(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause) {
	SendMessage(mWnd, WM_COMMAND, atoi(data), 0);
}
int stylecheck(char* stylein) {
	char*temp;
	char*temp2;
	int out = 0;
	temp = gettok(stylein, 1, " ",NULL,NULL);
	if (strlen(temp) > 7) {
		temp2 = new char[8];
		strncpy(temp2,temp,7);
		temp2[7] = '\0';
		if (strcmp(temp2,"$style(") == NULL) {
			delete[] temp2;
			temp2 = gettok(temp,-2,"(",NULL,NULL);
			temp2[strlen(temp2) - 1] = '\0';
			out = atoi(temp2);
			if (out == 0) out = -1;
		}
		delete[] temp2;
	}
	delete[] temp;
	return out;
}
ItemInfo iconcheck(char* iconin,HWND mWnd, bool*isicon) {
	ItemInfo myitem;
	char*temp;
	temp = gettok(iconin,1," ",NULL,NULL);
	charreplace(temp,'>',':');
	CharLower(temp);
	char*temp2 = new char[lstrlen(temp) + 1];
	lstrcpy(temp2,temp);
	if (lstrlen(temp2) >= 6) {
		temp2[6] = '\0';
	}
	//
	if (strlen(temp) > 6) {
		temp2 = new char[7];
		strncpy(temp2,temp,6);
		temp2[6] = '\0';
		if (strcmp(temp2,"$null(") == NULL) {
			delete[] temp2;
			temp2 = gettok(temp,-2,"(",NULL,NULL);
			temp2[strlen(temp2) - 1] = '\0';
			*isicon = true;
			if ((long)gettok(temp2,0,"?",NULL,NULL) == 1) {
				call_alias(mWnd,0,temp2);
				delete[] temp2;
				temp2 = new char[lstrlen(mData)]; lstrcpy(temp2,mData + 1);
				myitem.icon = (HICON)LoadImage(NULL, temp2,IMAGE_ICON,16,16,LR_LOADFROMFILE);
				myitem.rollover = myitem.icon;
			}
			else {
				temp = gettok(temp2,2,"?",NULL,NULL);
				temp2[pos(temp2,"?",1,0,0)] = '\0';
				call_alias(mWnd,0,temp);
				delete[] temp;
				temp = new char[lstrlen(mData)]; lstrcpy(temp,mData + 1);
				call_alias(mWnd,0,temp2);
				delete[] temp2;
				temp2 = new char[lstrlen(mData)]; lstrcpy(temp2,mData + 1);
				myitem.icon = (HICON)LoadImage(NULL, temp2,IMAGE_ICON,16,16,LR_LOADFROMFILE);
				myitem.rollover = (HICON)LoadImage(NULL, temp,IMAGE_ICON,16,16,LR_LOADFROMFILE);
			}
		}
		delete[] temp;
		delete[] temp2;
	}
	//
	return myitem;
}
int __stdcall popread(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause) {
	long numtok = -1;
	long next_tok = -1;
	char*temp;
	char*temp2;
	numtok = (long)gettok(data,0,"?",NULL,NULL);
	if (numtok != 5) {
		wsprintf(data, "%s", "E_INSUFFICIENT_PARAMETERS");
		return 3;
	}

/*	HANDLE file = CreateFile(<file>,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
	if (file == INVALID_HANDLE_VALUE) { error }
	unsigned long FileLength = GetFileSize(file,NULL);
	char*FileData = new char[FileLength];
	DWORD BytesRead = 0;
	ReadFile(file, FileData, FileLength,&BytesRead,NULL);
	CloseHandle(file);
	delete[] FileData;*/
	
	temp = gettok(data,1,"?",&numtok,&next_tok);
	HANDLE file = CreateFile(temp,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,NULL,NULL);
	delete[] temp;
	if (file == INVALID_HANDLE_VALUE) {
		wsprintf(data, "%s", "E_FILE_ACCESS_ERROR");
		return 3;
	}
	unsigned long FileLength = GetFileSize(file,NULL);
	char*FileData = new char[FileLength + 1];
	DWORD BytesRead = 0;
	ReadFile(file, FileData, FileLength,&BytesRead,NULL);
	CloseHandle(file);
	FileData[FileLength] = '\0';
	temp = gettok(data,2,"?",&numtok,&next_tok);
	UINT min = NoNegativeNumbers(atoi(temp));
	delete[] temp;
	temp = gettok(data,3,"?",&numtok,&next_tok);
	UINT max = NoNegativeNumbers(atoi(temp));
	delete[] temp;
	temp = gettok(data,4,"?",&numtok,&next_tok);
	UINT popx = atoi(temp);
	delete[] temp;
	temp = gettok(data,5,"?",&numtok,&next_tok);
	UINT popy = atoi(temp);
	delete[] temp;
	numtok = -1;
	next_tok = -1;
	long lines = (long)gettok(FileData,0,"\r",&numtok,NULL);
	UINT flags;
	UINT loop;
	UINT cnt = 0;
	UINT ocnt = 0;
	UINT menuitem = 1;
	UINT subcount = 0;
	UINT charcount;
	UINT charnum;
	int style = 0;
	long i = 1;
	std::vector<HMENU> hSubMenu;
	hSubMenu.clear();
	hSubMenu.push_back( CreatePopupMenu() );
	popreadmenu = hSubMenu[0];
	PopreadMenuItems.clear();
	char*str = new char[1];
	char*buf = new char[11];
	char*subcommand;
	char*substrone;
	bool issub;
	bool isicon;
	ItemInfo myitem;
	while ((i <= max) && (i <= lines)) {
		delete[] str;
		str = gettok(FileData,i,"\r",&numtok,&next_tok);
		charreplace(str,'\n','\0');
		chartrimleading(str," \t");
		chartrimtrailing(str," \t");
		if (lstrlen(str) <= 0) {
			i++;
			continue;
		}
		if (i >= min) {
			cnt = lstrlen(str);
			chartrimleading(str,".");
			cnt = cnt - lstrlen(str);
			if (lstrlen(str) == 0) {
				i++;
				continue;
			}
			if (cnt > ocnt) {
				cnt = ocnt;
			}
			else {
				ocnt = cnt;
			}
			while (hSubMenu.size() < cnt + 1) {
				hSubMenu.push_back( CreatePopupMenu() );
			}
			loop = 251;
			issub = false;
			temp = gettok(str,1,":",NULL,NULL);
			temp2 = gettok(temp,1," ",NULL,NULL);
			delete[] temp;
			if (strlen(temp2) > 10) {
				temp = new char[11];
				strncpy(temp,temp2,10);
				temp[10] = '\0';
				if (strcmp(temp,"$submenu($") == NULL) {
					delete[] temp;
					temp = gettok(temp2,2,"(",NULL,NULL);
					delete[] temp2;
					temp2 = gettok(temp,1,")",NULL,NULL);
					delete[] temp;
					subcommand = temp2;
					if (strcmp(subcommand,"$") == NULL) {
						delete[] subcommand;
					}
					else {
						issub = true;
						loop = 0;
					}
				}
				else {
					delete[] temp;
					delete[] temp2;
				}
			}
			while (loop <= 251) {
				if (issub == true) {
					if (loop == 0) {
						temp = new char[lstrlen(subcommand) + 8];
						lstrcpy(temp,subcommand);
						lstrcat(temp,"(begin)");
						call_alias(mWnd,0,temp);
						delete[] temp;
						delete[] str;
						str = new char[lstrlen(mData) + 1]; lstrcpy(str,mData);
						substrone = new char[lstrlen(subcommand) + 4];
						lstrcpy(substrone,subcommand);
						lstrcat(substrone,"(1)");
						call_alias(mWnd,0,substrone);
						delete[] substrone;
						substrone = new char[lstrlen(mData) + 1]; lstrcpy(substrone,mData);
						if ((lstrlen(substrone) == 0) || (((long)gettok(substrone,0,":",NULL,NULL) < 2) && (strcmp(substrone," -") != 0))) {
							temp = new char[lstrlen(subcommand) + 6];
							lstrcpy(temp,subcommand);
							lstrcat(temp,"(end)");
							call_alias(mWnd,0,temp);
							delete[] temp;
							delete[] str;
							delete[] substrone;
							break;
						}
					}
					else if (loop == 1) {
						delete[] str;
						str = new char[lstrlen(substrone) + 1]; lstrcpy(str,substrone);
						delete[] substrone;
					}
					else {
						itoa(loop,buf,10);
						delete[] str;
						str = new char[lstrlen(subcommand) + lstrlen(buf) + 3];
						lstrcpy(str,subcommand);
						lstrcat(str,"(");
						lstrcat(str,buf);
						lstrcat(str,")");
						call_alias(mWnd,0,str);
						delete[] str;
						str = new char[lstrlen(mData) + 1]; lstrcpy(str,mData);
						if ((lstrlen(str) == 0) || (((long)gettok(str,0,":",NULL,NULL) < 2) && (strcmp(str," -") != 0))) {
							delete[] str;
							str = new char[lstrlen(subcommand) + 6];
							lstrcpy(str,subcommand);
							lstrcat(str,"(end)");
							call_alias(mWnd,0,str);
							delete[] str;
							str = new char[lstrlen(mData) + 1]; lstrcpy(str,mData);
							loop = 252;
							if ((lstrlen(str) == 0) || (((long)gettok(str,0,":",NULL,NULL) < 2) && (strcmp(str," -") != 0))) {
								break;
							}
						}
					}
				}
				temp = gettok(str,1,":",NULL,NULL);
				chartrimleading(temp," ");
				isicon = false;
				myitem = iconcheck(temp,mWnd,&isicon);
				if (isicon) {
					temp2 = gettok(temp,-2," ",NULL,NULL);
					delete[] temp;
					temp = temp2;
				}
				else {
					myitem.icon = NULL;
					myitem.rollover = NULL;
				}
				call_alias(mWnd,0,temp);
				delete[] temp;
				temp = new char[lstrlen(mData) + 1]; lstrcpy(temp,mData);
				chartrimleading(temp," ");
				flags = 0;
				style = stylecheck(temp);
				if (style) {
					temp2 = gettok(temp,-2," ",NULL,NULL);
					delete[] temp;
					temp = temp2;
				}
				temp2 = new char[11];
				sprintf(temp2,"%d",style);
				delete[] temp2;
				if (lstrlen(temp) != 0) {
					switch (style) {
						case 1:	flags |= MF_CHECKED; break;
						case 2:	flags |= MF_GRAYED; break;
						case 3:	flags |= MF_GRAYED; flags |= MF_CHECKED; break;
					}
					myitem.text = new char[lstrlen(temp) + 1];
					lstrcpy(myitem.text,temp);
					myitem.menuchar = '\0';
					charnum = lstrlen(myitem.text);
					for (charcount = 0;charcount < charnum;charcount++) {
						if (myitem.text[charcount] == '&') {
							if (myitem.text[charcount + 1] == '&') {
								charcount++;
							}
							else {
								myitem.menuchar = myitem.text[charcount + 1];
							}
						}
					}
					myitem.id = new char[11]; myitem.id[0] = '\0';
					myitem.cmd = new char[11]; myitem.cmd[0] = '\0';
					if ((long)gettok(str,0,":",NULL,NULL) == 1) {


						flags |= MF_OWNERDRAW;
						flags |= MF_POPUP;

						if (!lstrcmp(temp,"-")) {
							AppendMenu(hSubMenu[cnt],MF_SEPARATOR, menuitem, "");
						}
						else {
							if (hSubMenu.size() < cnt + 2) {
								while (hSubMenu.size() < cnt + 2) {
									cnt = cnt;
									hSubMenu.push_back( CreatePopupMenu() );
								}
							}
							else {
								hSubMenu[cnt + 1] = CreatePopupMenu();
							}
							ocnt = cnt + 1;
							itoa(menuitem,myitem.id,10);
							myitem.submenu = hSubMenu[cnt + 1];
							AppendMenu(hSubMenu[cnt],flags,(UINT)myitem.submenu,myitem.id);
						}

					}
					else {
						if ((lstrcmp(temp,"-") != NULL) || (style)) {
							flags |= MF_OWNERDRAW;
						}
						delete[] myitem.cmd;
						myitem.cmd = gettok(str,-2,":",NULL,NULL);
						itoa(menuitem,myitem.id,10);
						myitem.submenu = NULL;
						AppendMenu(hSubMenu[cnt],flags,menuitem,myitem.id);
					}
					delete[] temp;
					PopreadMenuItems.push_back(myitem);
					menuitem++;
				}
				loop++;
			}
		}
		i++;
	}
	UINT id = TrackPopupMenu(hSubMenu[0], TPM_RIGHTBUTTON | TPM_RETURNCMD , popx, popy, 0, pophwnd, NULL);
	if (id) {
		delete[] str;
		str = new char[lstrlen(PopreadMenuItems[id-1].cmd) + 3];
		lstrcpy(str,"//");
		lstrcat(str,PopreadMenuItems[id-1].cmd);
		call_alias(mWnd, 1, str);
	}
	DestroyMenu(hSubMenu[0]);
	ocnt = PopreadMenuItems.size();
	delete[] str;
	str = new char[20]; str[0] = '\0';
	sprintf(str,"%u",ocnt);
	delete[] str;
	for(cnt = 0;cnt < ocnt;cnt++) {
		myitem = PopreadMenuItems[cnt];
		delete[] myitem.text;
		delete[] myitem.cmd;
		delete[] myitem.id;
		if (myitem.icon) {
			DeleteObject(myitem.icon);
		}
		if (myitem.rollover) {
			DeleteObject(myitem.rollover);
		}
	}
	PopreadMenuItems.clear();
	strcpy(data,"S_OK");
	delete[] FileData;
	return 3;	
}
UINT NoNegativeNumbers(int number) {
	if (number < 0) return 0;
	return number;
}