/*
 *  winamp.c
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */

#include "aircdll.h"
#include "winamp.h"

HWND winamphwnd = NULL;

int winamp_cmdc2id (const char *s)
{
	if (!lstrcmpi(s, "prev")) {
		return WINAMP_BTN_PREV;
	} else if (!lstrcmpi(s, "play")) {
		return WINAMP_BTN_PLAY;
	} else if (!lstrcmpi(s, "pause")) {
		return WINAMP_BTN_PAUSE;
	} else if (!lstrcmpi(s, "stop")) {
		return WINAMP_BTN_STOP;
	} else if (!lstrcmpi(s, "next")) {
		return WINAMP_BTN_NEXT;
	} else if (!lstrcmpi(s, "rew5")) {
		return WINAMP_REW5;
	} else if (!lstrcmpi(s, "fadestop")) {
		return WINAMP_FADESTOP;
	} else if (!lstrcmpi(s, "ffwd5")) {
		return WINAMP_FFWD5;
	} else if (!lstrcmpi(s, "plstart")) {
		return WINAMP_PL_START;
	} else if (!lstrcmpi(s, "openurl")) {
		return WINAMP_OPENURL;
	} else if (!lstrcmpi(s, "stopatend")) {
		return WINAMP_STOPATEND;
	} else if (!lstrcmpi(s, "plend")) {
		return WINAMP_PL_END;
	} else if (!lstrcmpi(s, "fileinfo")) {
		return WINAMP_FILEINFO;
	} else if (!lstrcmpi(s, "visoptions")) {
		return WINAMP_OPTIONS_VIS;
	} else if (!lstrcmpi(s, "vispluginoptions")) {
		return WINAMP_OPTIONS_VISPLUGIN;
	} else if (!lstrcmpi(s, "vispluginrun")) {
		return WINAMP_RUN_VISPLUGIN;
	} else if (!lstrcmpi(s, "titlescroll")) {
		return WINAMP_TITLE_AUTOSCROLL;
	} else if (!lstrcmpi(s, "winshade")) {
		return WINAMP_WINDOWSHADE;
	} else if (!lstrcmpi(s, "plshade")) {
		return WINAMP_PL_WINDOWSHADE;
	} else if (!lstrcmpi(s, "double")) {
		return WINAMP_DOUBLESIZE;
	} else if (!lstrcmpi(s, "visible")) {
		return WINAMP_VISIBLE;
	} else if (!lstrcmpi(s, "minibrowser")) {
		return WINAMP_MINIBROWSER;
	} else if (!lstrcmpi(s, "easymove")) {
		return WINAMP_EASYMOVE;
	} else if (!lstrcmpi(s, "repeat")) {
		return WINAMP_REPEAT;
	} else if (!lstrcmpi(s, "shuffle")) {
		return WINAMP_SHUFFLE;
	} else if (!lstrcmpi(s, "jump2time")) {
		return WINAMP_JUMP2TIME;
	} else if (!lstrcmpi(s, "jump2file")) {
		return WINAMP_JUMP2FILE;
	} else if (!lstrcmpi(s, "skinsel")) {
		return WINAMP_SKIN_SELECTOR;
	} else if (!lstrcmpi(s, "vispluginconfig")) {
		return WINAMP_CONFIG_VISPLUGIN;
	} else if (!lstrcmpi(s, "skinreload")) {
		return WINAMP_SKIN_RELOAD;
	} else if (!lstrcmpi(s, "exit")) {
		return WINAMP_EXIT;
	} else if (!lstrcmpi(s, "plback10")) {
		return WINAMP_PL_BACK10;
	} else if (!lstrcmpi(s, "cdplay")) {
		return WINAMP_CD_PLAY;
	} else if (!lstrcmpi(s, "eq")) {
		return WINAMP_OPTIONS_EQ;
	} else if (!lstrcmpi(s, "pl")) {
		return WINAMP_OPTIONS_PLEDIT;
	} else if (!lstrcmpi(s, "volup")) {
		return WINAMP_VOLUMEUP;
	} else if (!lstrcmpi(s, "voldown")) {
		return WINAMP_VOLUMEDOWN;
	} else if (!lstrcmpi(s, "fileplay")) {
		return WINAMP_FILE_PLAY;
	} else if (!lstrcmpi(s, "prefs")) {
		return WINAMP_OPTIONS_PREFS;
	} else if (!lstrcmpi(s, "ontop")) {
		return WINAMP_OPTIONS_AOT;
	} else if (!lstrcmpi(s, "about")) {
		return WINAMP_HELP_ABOUT;
	} else {
        return 0;
	}
}

int winamp_cmdu2id (const char *s)
{
	if (!lstrcmpi(s, "version")) {
		return IPC_GETVERSION;
	} else if (!lstrcmpi(s, "plclear")) {
		return IPC_DELETE;
	} else if (!lstrcmpi(s, "plplaysel")) {
		return IPC_STARTPLAY;
	} else if (!lstrcmpi(s, "isplaying")) {
		return IPC_ISPLAYING;
	} else if (!lstrcmpi(s, "getoutputtime")) {
		return IPC_GETOUTPUTTIME;
	} else if (!lstrcmpi(s, "jumptotime")) {
		return IPC_JUMPTOTIME;
	} else if (!lstrcmpi(s, "plwrite")) {
		return IPC_WRITEPLAYLIST;
	} else if (!lstrcmpi(s, "plsetpos")) {
		return IPC_SETPLAYLISTPOS;
	} else if (!lstrcmpi(s, "setvol")) {
		return IPC_SETVOLUME;
	} else if (!lstrcmpi(s, "setpan")) {
		return IPC_SETPANNING;
	} else if (!lstrcmpi(s, "plgetlength")) {
		return IPC_GETLISTLENGTH;
	} else if (!lstrcmpi(s, "plgetpos")) {
		return IPC_GETLISTPOS;
	} else if (!lstrcmpi(s, "gettrackinfo")) {
		return IPC_GETINFO;
	} else if (!lstrcmpi(s, "geteqdata")) {
		return IPC_GETEQDATA;
	} else if (!lstrcmpi(s, "seteqdata")) {
		return IPC_SETEQDATA;
	} else if (!lstrcmpi(s, "addbookmark")) {
		return IPC_ADDBOOKMARK;
	} else if (!lstrcmpi(s, "restartwinamp")) {
		return IPC_RESTARTWINAMP;
	} else {
		return -1;
	}
}

MircFunc winamp (FUNCPARMS)
{
	char *tmp, *cmd, *tnum, *p, title[2048], *plpos, *plfile;
    char buff[4096 + 1], *auxl, line[MAXSTRINGLEN], *auxb;
	int id, auxn, parm;
	HWND winamphwnd;
	HANDLE hfile = NULL;
	DWORD  bytesread;
	unsigned int wpos, nline, plposcounter, pos;
	register int itmp;

	winamphwnd = FindWindow("Winamp v1.x", NULL);
/*	winamphwnd = FindWindow("STUDIO", NULL); */ /* winamp > winamp3 */
	if (!winamphwnd) {
		r_err("WINAMP", "There is no winamp session open");
	}

	tmp = data;
	cmd = getword(&tmp);

	if (!lstrcmpi(cmd, "getcurrsong")) {
		GetWindowText(winamphwnd, title, sizeof(title));
		p = title + lstrlen(title) - 8;
		while (p >= title) {
			if (!mystrcmp(p, "- Winamp"))
				break;
			p--;
		}
		if (p >= title)
			p--;
		while (p >= title && *p == ' ')
			p--;
		*++p = 0;
		r_ok(title);
	}

    if (!lstrcmpi(cmd, "plpos2entry")) {
        plpos = getword(&tmp);
        plfile = tmp;
        plposcounter = 0;
        wpos = 0;
        auxl = line;
        nline = 0;
        if (!isnum(plpos, 0)) {
            r_err("PLPOS", "Invalid playlist position number");
        }
        pos = atoi(plpos);
        if (myfileopen(&hfile, data, plfile, FALSE))
            return 3;
    	do {
		    for (itmp = 0; itmp < 4096 + 1; ++itmp)
    			buff[itmp] = 0;
		    if (ReadFile(hfile, buff, 4096, &bytesread, NULL)) {
    			for (auxb = buff, itmp = 0; *auxb && itmp < 4906 + 1; auxb++, ++itmp) {
				    if (++wpos == (MAXSTRINGLEN - 4) || *auxb == 10) {
    					*auxl = 0;
					    if (++nline > 1) {
                            if (*line != '#') {
                                if (plposcounter == pos) {
                                    CloseHandle(hfile);
                                    wsprintf(data, "+OK %s", line);
                                    return 3;
                                }
                                plposcounter++;
                            }
					    } else {
						    if (mystrcmp(line, "#EXTM3U")) {
    							CloseHandle(hfile);
							    r_err("PLAYLISTFILE", "Invalid M3U Playlist File");
						    }
					    }
					    auxl = line;
					    wpos = 0;
                    } else if (*auxb != 13) {
					    *auxl++ = *auxb;
				    }
			    }
		    }
	    } while (bytesread == 4096);
	    CloseHandle(hfile);
        r_err("PLNOTFOUND", "Playlist entry not found for that index number");
    }

	id = winamp_cmdc2id(cmd);
	if (id) {
		wsprintf(data, "+OK %d", SendMessage(winamphwnd, WM_COMMAND, id, 0));
		return 3;
	}

	id = winamp_cmdu2id(cmd);
	switch (id) {
		case IPC_GETVERSION:
			auxn = (int)SendMessage(winamphwnd, WM_WA_IPC, 0, id);
			auxn = auxn - 0x2000;
			wsprintf(data, "+OK 2.%d%d", auxn/256, (auxn - (auxn/256)*256) / 16);
			return 3;
		/* void */
		case IPC_DELETE:
		case IPC_STARTPLAY:
		case IPC_ISPLAYING:
		case IPC_WRITEPLAYLIST:
		case IPC_GETLISTLENGTH:
		case IPC_GETLISTPOS:
		case IPC_RESTARTWINAMP:
			wsprintf(data, "+OK %d", SendMessage(winamphwnd, WM_WA_IPC, 0, id));
			return 3;
		/* int */
		case IPC_GETOUTPUTTIME:
		case IPC_JUMPTOTIME:
		case IPC_SETPLAYLISTPOS:
		case IPC_SETVOLUME:
		case IPC_SETPANNING:
		case IPC_GETINFO:
		case IPC_GETEQDATA:
		case IPC_SETEQDATA:
			tnum = getword(&tmp);
			if (!isnum(tnum, 0)) {
				r_err("NUMBER", "Parameter must be a valid number");
			}
			parm = atolp(tnum);
			wsprintf(data, "+OK %d", SendMessage(winamphwnd, WM_WA_IPC, parm, id));
			return 3;

		/* char* */
		case IPC_ADDBOOKMARK:
			wsprintf(data, "+OK %d", SendMessage(winamphwnd, WM_WA_IPC, (WPARAM)tmp, id));
			return 3;
	}

	r_err("CMD", "Invalid command");
}
