/*
 *  users.h
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */


#ifndef _USERS_H_
#define _USERS_H_

/*
 * Defines
 */

#define USERENTRY_COMMENT 0
#define USERENTRY_INFO    1
#define USERENTRY_LASTON  2
#define USERENTRY_PASS    3
#define USERENTRY_BOTADDR 4
#define USERENTRY_BOTFL   5
#define USERENTRY_HOSTS   6
#define USERENTRY_XTRA    7
#define USERENTRY_CONSOLE 8
#define USERENTRY_DCCDIR  9
#define USERENTRY_FWD     10
#define USERENTRY_FSTAT   11

#define USERIBEI_IGNORE 0
#define USERIBEI_BAN    1
#define USERIBEI_EXEMPT 2
#define USERIBEI_INVITE 3

#define IGNORE_NAME "*ignore"
#define BAN_NAME    "*ban"
#define EXEMPT_NAME "*exempt"
#define INVITE_NAME "*Invite"

#define getnet(x) \
	usernetw_t tmpnetw; \
	char *tmpgetnet; \
	x = data; \
	tmpgetnet = getword(&(x)); \
	if (!rfc_cmp(tmpgetnet, "-")) { users_netw_active(usernetstart); } \
	else { \
		tmpnetw = users_netw_find(tmpgetnet, FALSE); \
		if (!tmpnetw) { r_err("NETW", "Invalid network"); } \
		users_netw_active(tmpnetw); \
	}

/*
 * Structures
 */


typedef struct userentry_s {
	union {
		char *cont;
		struct stringchain_s *list;
	};
	int type;
	char *name;
	struct userentry_s *next;
} *userentry_t;

typedef struct userchan_s {
	char *flags, *channel, *uflags, *info;
	unsigned int laston;
	struct userchan_s *next;
} *userchan_t;

typedef struct usermain_s {
	char *handle, *flags, *uflags;
	hash_t hh;
	struct userchan_s *chans;
	struct userentry_s *entries;
	struct usermain_s *next;
} *usermain_t;

typedef struct useribeientry_s {
	char *mask, *setby, *msg;
	hash_t hash;
	unsigned int seton, expire, lastactive;
	tbool perm, sticky;
	struct useribeientry_s *next;
} *useribeientry_t;

typedef struct useribeihead_s {
	char *chan;
	hash_t hash;
	unsigned int num; /* number of entries */
	struct useribeientry_s *entry;
	struct useribeihead_s *next;
} *useribeihead_t;

typedef struct usernetw_s {
	char *netw;
	hash_t hh;
	struct useribeihead_s *ibei[4];
	struct usermain_s *users;
	struct usernetw_s *next;
} *usernetw_t;


/*
 * Prototypes
 */

void users_init ();
usernetw_t users_netw_find (char *, tbool);
unsigned int users_netw_count ();
void users_netw_active (usernetw_t);
void users_netw_remove (usernetw_t);
int users_netw_del (char *ntw);
int users_netw_cleanup (tbool);
usermain_t users_user_find (char *, tbool);
unsigned int users_user_count ();
char *users_flags_nodup (char *);
userchan_t users_chan_find (usermain_t, char *, tbool);
void users_chan_remove (userchan_t);
void users_entry_remove (userentry_t);
void users_user_remove (usermain_t);
int users_user_cleanup ();
int users_user_add (char *);
int users_user_del (char *);
int users_chrec_add (usermain_t, char *);
int users_chrec_del (usermain_t, char *);
int users_flags_set (usermain_t, char *, int, char *);
char *users_flags_get (usermain_t, int, char *);
int users_entry_type2num (char *);
tbool users_entry_find (usermain_t, char *, tbool);
int users_entry_set (usermain_t, char *, char *);
int users_entry_del_w (usermain_t, char *, char *);
int users_laston_set (usermain_t, char *, unsigned int);
char *users_flags_fix (char *);
usermain_t users_uhost2handle (char *);
usermain_t users_uhost2handle_equalnomatch (char *);
int users_ibei_char2id (char);
unsigned int users_ibei_expire (usernetw_t);
void users_ibei_init (usernetw_t);
void users_ibei_chan_delnode (useribeihead_t);
unsigned int users_ibei_chan_count (int);
unsigned int users_ibei_count (useribeihead_t);
void users_ibei_delnode (useribeientry_t);
void users_ibei_formatline (char *, int, useribeientry_t);
useribeihead_t users_ibei_chan_find (int, char *, tbool, tbool);
useribeientry_t users_ibei_find (int, char *, char *, char *, char *, unsigned int, unsigned int, unsigned int, tbool, tbool, tbool, tbool);
useribeientry_t users_ibei_match (int, char *, char *);
int users_ibei_lineadd (char, char *, char *);

#endif /* _USERS_H_ */

