/*
 * tabolib - tabo's crappy C library
 * Copyright (C) 2001, 2002 Gustavo Picon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _TABOLIB_H_
#define _TABOLIB_H_

#ifdef __cplusplus
extern "C" {
#endif


#ifdef TABOLIB_USE_TIME
	#include <time.h>
#endif

/*
 * #defines & typedefs
 */

#define ERR_TABOLIB_BADFILEBUFFER   1
#define ERR_TABOLIB_COULDNTOPENFILE 2
#define ERR_TABOLIB_FILENOTFOUND    3

typedef unsigned char tbool;
typedef unsigned int hash_t;

/*
 * Prototypes
 */

char *cmalloc (int);
void *smalloc (int);
tbool mfree (void *);
void tabolib_onload ();
char *getword (char **);
char *getnexttok (char **, int);
int atolp (char *);
tbool isnum (char *, int);
tbool isincs (char *, char);
unsigned int countchar (char *, int);
char *removechar (char *, int);
char *removelf (char *);
char *mirchar (char *);
unsigned int now ();
int mystrcmp (char *, char *);
tbool ishostmask (register char *);
int match (register char *, register char *, tbool);
tbool iswm (char *, char *);
tbool iswmcs (char *, char *);
hash_t myhash (char *);
hash_t rfchash (char *);
tbool isfile (char *);
char *file_get (char *);
int file_open_read (HANDLE *, char *);
int file_open_write (HANDLE *, char *);
tbool file_write (HANDLE *, char *);
void cmdrun (char *, char *);
char *fixpath (char *, char *, char *);
int rfc_cmp (char *, char *);
int rfc_tolower (int);
int rfc_toupper (int);
char *rfc_strtoupper (char *);
char *rfc_strtolower (char *);

#ifdef __cplusplus
}
#endif

#endif /* _TABOLIB_H_ */

