/*
 *  small.c
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */

#include "aircdll.h"
#include <shlobj.h>
#include <commdlg.h>
#include "small.h"

HMENU menubar = NULL;
char matchtok_tokens[MAXSTRINGLEN];

void savemenubar(HWND w, tbool b)
{
	HMENU m;

	m = GetMenu(w);
	if (IsMenu(m))
		menubar = m;
	else if (b)
		menubar = NULL;
}

/*
 * Small Exported functions
 */

/*
 * SetTitle <hwnd> [string]
 */
MircFunc SetTitle(FUNCPARMS)
{
	char *tmp;
	HWND window;

	tmp = data;
	window = (HWND)atolp(getword(&tmp));
	if (IsWindow(window)) {
		SetWindowText(window, tmp);
		r_ok("");
	}
	r_err("BADWIN", "Invalid HWND");
}

/*
 * GetTitle <hwnd>
 */
MircFunc GetTitle(FUNCPARMS)
{
	char *tmp, s[MAXSTRINGLEN];
	HWND window;

	tmp = data;
	window = (HWND)atolp(getword(&tmp));
	if (IsWindow(window)) {
		GetWindowText(window, s, MAXSTRINGLEN - 5);
		r_ok(s);
	}
	r_err("BADWIN", "Invalid HWND");
}

/*
 * SetMircTitle <string>
 */
MircFunc SetMircTitle(FUNCPARMS)
{
	SetWindowText(mWnd, data);
	r_ok("");
}

/*
 * GetMircTitle
 */
MircFunc GetMircTitle(FUNCPARMS)
{
	char r[MAXSTRINGLEN];

	GetWindowText(mWnd, r, MAXSTRINGLEN - 5);
	r_ok(r);
}

/*
 * GetWindowsDir
 */
MircFunc GetWindowsDir(FUNCPARMS)
{
	char r[MAXSTRINGLEN];

	GetWindowsDirectory(r, MAXSTRINGLEN - 5);
	r_ok(r);
}

/*
 * GetSystemDir
 */
MircFunc GetSystemDir(FUNCPARMS)
{
	char r[MAXSTRINGLEN];

	GetSystemDirectory(r, MAXSTRINGLEN - 5);
	r_ok(r);
}

/*
 * GetTempDir
 */
MircFunc GetTempDir(FUNCPARMS)
{
	char r[MAXSTRINGLEN];

	GetTempPath(MAXSTRINGLEN - 5, r);
	r_ok(r);
}

/*
 * HideMenuBar
 */
MircFunc HideMenuBar(FUNCPARMS)
{
	savemenubar(mWnd, FALSE);
	SetMenu(mWnd, NULL);
	r_ok("");
}

/*
 * ShowMenuBar
 */
MircFunc ShowMenuBar(FUNCPARMS)
{
	if (IsMenu(menubar)) {
		SetMenu(mWnd, menubar);
		r_ok("");
	}
	r_err("BADMENU", "Stored Menu handle is messed up :/");

}

/*
 * MatchTokString <wildstring>
 */
MircFunc MatchTokString (FUNCPARMS)
{
	lstrcpy(matchtok_tokens, data);
	wsprintf(data, "+OK %s", matchtok_tokens);
	return 3;
}

char *matchtokaux (char *string, int tokchar, char *result, tbool cs /* case sensitive */)
{
	char saux[MAXSTRINGLEN + 8], maux[MAXSTRINGLEN + 8], toks[MAXSTRINGLEN], *word, *ptoks;
	int len;

	ptoks = toks;
	wsprintf(saux, "* %s *", string);
	lstrcpy(toks, matchtok_tokens);
	for (;;) {
		word = getnexttok(&ptoks, tokchar);
		if (*word == ' ')
			++word;
		len = lstrlen(word);
		if (len) {
			if (word[len - 1] == ' ')
				word[len-- - 1] = 0;
			lstrcpy(maux, word);
			if (len > 2) {
				if (word[0] != '*' || word[1] != ' ')
					wsprintf(maux, "* %s", word);
				if (word[len - 2] != ' ' || word[len - 1] != '*')
					lstrcat(maux, " *");
			}
			if (match(maux, saux, cs)) {
				lstrcpy(result, word);
				return result;
			}
			continue;
		}
		return NULL;
	}
}

/*
 * MatchTok <+flags> <tokchar> <string>
 */
MircFunc MatchTok (FUNCPARMS)
{
	char *tmp, word[MAXSTRINGLEN], *flags, *aux;
	int tokchar = atolp(getword(&tmp));

        tmp = data;
        word[0] = 0;
        flags = getword(&tmp);
        tokchar = atolp(getword(&tmp));

	if (!tokchar || tokchar > 255) {
		r_err("TOKCHAR", "Invalid token character number");
	}
	if (isincs(flags, 'r')) {
		for (aux = tmp; *aux; ++aux) {
			if (isincs(",.:-\"'()[]_!?", *aux))
				*aux = ' ';
		}
	}
	matchtokaux(tmp, tokchar, word, isincs(flags, 'c')?TRUE:FALSE );
	if (lstrlen(word)) {
		wsprintf(data, "+OK %s", word);
		return 3;
	}
	r_err("FOUND", "No token matched the string");
}

/*
 * PickColor [DefColor] [CustomColor1] ... [CustomColor16]
 */
MircFunc PickColor(FUNCPARMS)
{
	char *tmp = data;
	CHOOSECOLOR ctmp;
	/* static, to re-use if no parms are given */
	static DWORD curgb;
	static COLORREF customcolor[16];
	int i;

	if (*tmp) {
		curgb = atolp(getword(&tmp));
		for (i = 0; i < 16 && *tmp; ++i)
			customcolor[i] = atolp(getword(&tmp));
	}

	ctmp.lStructSize = sizeof(CHOOSECOLOR);
	ctmp.hwndOwner = mWnd;
	ctmp.hInstance = NULL;
	ctmp.rgbResult = curgb;
	ctmp.lpCustColors = (COLORREF*)customcolor;
	ctmp.Flags = CC_RGBINIT|CC_FULLOPEN;
	ctmp.lCustData = (LPARAM)NULL;
	ctmp.lpfnHook = NULL;
	ctmp.lpTemplateName = NULL;

	if(ChooseColor(&ctmp)) {
		curgb = ctmp.rgbResult; /* storing it to re-use */
		wsprintf(data,"+OK %d", ctmp.rgbResult);
		return 3;
	}
	r_err("CANCEL", "User didn't click the OK button");
}

/*
 * DLLInfo
 */
MircFunc DllInfo(FUNCPARMS)
{
	r_ok(DLLINFO);
}

