/*
 *  opt.h
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */

#ifndef _OPT_H_
#define _OPT_H_


/*
 * Structures
 */

typedef struct scriptopt_s {
	char *item, *cont;
	hash_t hi;
	struct scriptopt_s *next;
} *scriptopt_t;

typedef struct scriptoptnc_s {
	struct scriptopt_s *list;
	char *netw, *chan;
	hash_t hn, hc;
	struct scriptoptnc_s *next;
} *scriptoptnc_t;

typedef struct scriptoptlist_s {
	struct scriptoptnc_s *head;
	char *table;
	hash_t hash;
	struct scriptoptlist_s *next;
} *scriptoptlist_t;

/*
 * Prototypes
 */

scriptoptnc_t opt_nc_find (char *, char *, tbool, tbool);
scriptopt_t opt_find (char *, char *, char *, char *, tbool, tbool);
void opt_delnode(scriptopt_t);
void opt_nc_delnode(scriptoptnc_t);
unsigned int opt_nc_delmembers(scriptoptnc_t);
void opt_list_delnode(scriptoptlist_t);
unsigned int opt_list_delmembers(scriptoptlist_t);
unsigned int opt_cleanup();
tbool optHeader(char *);
int opt_intset (char *);



#endif /* _OPT_H_ */

