/*
 *  opt.c
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */

#include "aircdll.h"
#include "opt.h"

scriptoptlist_t scriptoptstart = NULL;

/*
 *  Internal
 */

scriptoptnc_t opt_nc_find (char *netw, char *chan, tbool create, tbool remove)
{
	hash_t hn, hc;
	scriptoptnc_t t, prev = NULL;

	if (!netw)
		netw = "";
	if (!chan)
		chan = "";
	hn = rfchash(netw);
	hc = rfchash(chan);
	for (t = scriptoptstart->head; t; t = t->next) {
		if ( hn == t->hn && hc == t->hc && !rfc_cmp(netw, t->netw) && !rfc_cmp(chan, t->chan) ) {
			if (remove) {
				if (prev)
					prev->next = t->next;
				else
					scriptoptstart->head = NULL;
				opt_nc_delmembers(t);
				opt_nc_delnode(t);
				return NULL;
			}
			return t;
		}
		prev = t;
	}

	if (create) {
		t = (scriptoptnc_t) smalloc(sizeof(struct scriptoptnc_s));
		t->hn = hn;
		t->hc = hc;
		t->netw = cmalloc(lstrlen(netw) + 1);
		lstrcpy(t->netw, netw);
		t->chan = cmalloc(lstrlen(chan) + 1);
		lstrcpy(t->chan, chan);
		if (prev)
			prev->next = t;
		else
			scriptoptstart->head = t;
		t->next = NULL;
		t->list = NULL;
		return t;
	}
	return NULL;
}
scriptopt_t opt_find (
			   char *netw,
			   char *chan,
			   char *item,
			   char *cont,
			   tbool create,
			   tbool remove
			   )
{
	hash_t hi;
	scriptopt_t t, prev = NULL;
	scriptoptnc_t optnc;

	hi = rfchash(item);
	optnc = opt_nc_find(netw, chan, create, FALSE);
	if (!optnc)
		return NULL;
	if (!cont)
		cont = "";
	for (t = optnc->list; t; t = t->next) {
		if ( hi == t->hi && !rfc_cmp(item, t->item) ) {
			if (remove) {
				if (prev) {
					prev->next = t->next;
				} else if (t->next) {
					optnc->list = t->next;
				} else {
					opt_nc_find(netw, chan, FALSE, TRUE); /* remove the node if there are no entries left */
				}
				opt_delnode(t);
				return NULL;
			}
			if (create) {
				if (t->cont) {
					mfree(t->cont);
				}
				t->cont = cmalloc(lstrlen(cont) + 1);
				lstrcpy(t->cont, cont);
			}
			return t;
		}
		prev = t;
	}

	if (remove)
		return NULL;

	if (create) {
		t = (scriptopt_t) smalloc(sizeof(struct scriptopt_s));
		t->hi = hi;
		t->item = cmalloc(lstrlen(item) + 1);
		lstrcpy(t->item, item);
		t->cont = cmalloc(lstrlen(cont) + 1);
		lstrcpy(t->cont, cont);
		if (prev) {
			prev->next = t;
		} else {
			optnc->list = t;
		}
		t->next = NULL;
		return t;
	}
	return NULL;
}
void opt_delnode (scriptopt_t t)
{
	mfree(t->item);
	mfree(t->cont);
	mfree(t);
}
void opt_nc_delnode (scriptoptnc_t t)
{
	mfree(t->netw);
	mfree(t->chan);
	mfree(t);
}
unsigned int opt_nc_delmembers(scriptoptnc_t t)
{
	scriptopt_t nt = NULL, nn;
	unsigned int c = 0;

	nt = t->list;
	while (nt) {
		nn = nt->next;
		opt_delnode(nt);
		++c;
		nt = nn;
	}
	t->list = NULL;
	return c;
}
void opt_list_delnode (scriptoptlist_t t)
{
	mfree(t->table);
	opt_list_delmembers(t);
	mfree(t);
}
unsigned int opt_list_delmembers(scriptoptlist_t t)
{
	scriptoptnc_t nct = t->head, ncn;
	unsigned int c = 0;

	while (nct) {
		ncn = nct->next;
		c += opt_nc_delmembers(nct);
		opt_nc_delnode(nct);
		nct = ncn;
	}
	t->head = NULL;
	return c;
}
unsigned int opt_getnumnodes (scriptoptlist_t t)
{
	scriptoptnc_t nct;
	scriptopt_t l;

	unsigned int c = 0;
	for (nct = t->head; nct; nct = nct->next) {
		for (l = nct->list; l; l = l->next)
			++c;
	}
	return c;
}
unsigned int opt_cleanup()
{
	unsigned int count = 0;
	scriptoptlist_t t = scriptoptstart, aux = NULL;

	while (t) {
		++count;
		aux = t;
		t = t->next;
		opt_list_delnode(aux);
	}
	scriptoptstart = NULL;
	return count;
}

tbool opt_header(char *table)
{
	hash_t hash = rfchash(table);
	scriptoptlist_t t, p = NULL;

	if (!*table)
		return FALSE;
	hash = rfchash(table);
	for (t = scriptoptstart; t; t = t->next) {
		if (hash == t->hash && !rfc_cmp(table, t->table)) {
			if (p) {
				p->next = t->next;
				t->next = scriptoptstart;
				scriptoptstart = t;
			}
			return TRUE;
		}
		p = t;
	}
	return FALSE;
}

int opt_intset (char *buff)
{
	char *tmp, *table, *flags, *netw, *chan, *item, *cont;

        netw = NULL;
        chan = NULL;
	tmp   = buff;
	table = getword(&tmp);
	if (!opt_header(table))
		return 1;
	flags = getword(&tmp);
	if (*flags != '+')
		return 2;
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);
	cont = removelf(tmp);
	if (!*item)
		return 3;
	opt_find(netw, chan, item, cont, TRUE, FALSE);
	return 0;
}

/*
 * Exported
 */

/*
 * OptTableAdd <table>
 */
MircFunc OptTableAdd (FUNCPARMS)
{
	char *tmp, *table;
	hash_t hash;
	scriptoptlist_t s;

	tmp = data;
	table  = getword(&tmp);
	if (!*table)
		r_err("TABLE", "Invalid table name");
	hash = rfchash(table);
	for (s = scriptoptstart; s; s = s->next) {
		if (s->hash == hash && !rfc_cmp(s->table, table))
			r_err("DUP", "There is already a table with that name");
	}
	s = (scriptoptlist_t) smalloc(sizeof(struct scriptoptlist_s));
	s->hash = hash;
	s->table = cmalloc(lstrlen(table) + 1);
	lstrcpy(s->table, table);
	s->head = NULL;
	s->next = scriptoptstart;
	scriptoptstart = s;
	r_ok("");
}

/*
 * OptTableDel <table>
 */
MircFunc OptTableDel (FUNCPARMS)
{
	char *tmp, *table;
	hash_t hash;
	scriptoptlist_t t, p = NULL;

	tmp = data;
	table  = getword(&tmp);
	if (!*table)
		r_err("TABLE", "Invalid table name");
	hash = rfchash(table);
	for (t = scriptoptstart; t; t = t->next) {
		if (t->hash == hash && !rfc_cmp(t->table, table)) {
			if (p)
				p->next = t->next;
			else if (t == scriptoptstart)
				scriptoptstart = t->next;
			opt_list_delnode(t);
			r_ok("");
		}
		p = t;
	}
	r_err("NOTFOUND", "Table not found");
}

/*
 * OptTableDelMatch <*table*>
 */
MircFunc OptTableDelMatch (FUNCPARMS)
{
	char *tmp, *table;
	scriptoptlist_t t, p, aux;
	unsigned int count, total;

        tmp = data;
        table  = getword(&tmp);
        t = scriptoptstart;
        p = aux = NULL;
        count = total = 0;
	if (!*table)
		r_err("MATCH", "Invalid match expression");
	while (t) {
		if (iswm(table, t->table)) {
			if (p)
				p->next = t->next;
			else if (t == scriptoptstart)
				scriptoptstart = t->next;
			aux = t;
			t = t->next;
			opt_list_delnode(aux);
			++count;
		} else {
			p = t;
			++total;
			t = t->next;
		}
	}
	wsprintf(data, "+OK %d %d", count, total);
	return 3; /* returns "removed total" */
}

/*
 * OptTableCount
 */
MircFunc OptTableCount (FUNCPARMS)
{
	unsigned int c = 0;
	scriptoptlist_t t;

	for (t = scriptoptstart; t; t = t->next)
		++c;
	wsprintf(data, "+OK %d", c);
	return 3;
}

/*
 * OptTableClear
 */
MircFunc OptTableClear (FUNCPARMS)
{
	wsprintf(data, "+OK %d", opt_cleanup());
	return 3;
}

/*
 * OptTableLoad <table> <file>
 */
MircFunc OptTableLoad (FUNCPARMS)
{
	char *tmp, *table, *auxl, *auxb, buff[4096 + 1], line[MAXSTRINGLEN], aux[4096];
	HANDLE hfile = NULL;
	DWORD  bytesread;
	unsigned int wpos, totalread, nline;
	register int itmp;

	tmp = data;
	table  = getword(&tmp);
        wpos = totalread = nline = 0;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	if (myfileopen(&hfile, data, tmp, FALSE))
		return 3;
	opt_list_delmembers(scriptoptstart);
	auxl = line;
	do {
		for (itmp = 0; itmp < 4096 + 1; ++itmp)
			buff[itmp] = 0;
		if (ReadFile(hfile, buff, 4096, &bytesread, NULL)) {
			for (auxb = buff, itmp = 0; *auxb && itmp < 4906 + 1; auxb++, ++itmp) {
				if (++wpos == (MAXSTRINGLEN - 4) || *auxb == 10) {
					*auxl = 0;
					if (++nline > 1) {
						wsprintf(aux, "%s %s", table, line);
						if (!opt_intset(aux))
							++totalread;
					} else {
						lstrcpy(aux, line);
						if (mystrcmp(aux, "#aircdll OptTable 1 - ")) {
							CloseHandle(hfile);
							r_err("OPTFILE", "Invalid Options File");
						}
					}
					auxl = line;
					wpos = 0;
				} else if (*auxb != 13) {
					*auxl++ = *auxb;
				}
			}
		}
	} while (bytesread == 4096);
	CloseHandle(hfile);
	wsprintf(data, "+OK %d", totalread);
	return 3;
}

/*
 * OptTableSave <table> <file>
 */
MircFunc OptTableSave (FUNCPARMS)
{
	char *tmp, *table, line[1024], rflags[10], rnetw[MAXSTRINGLEN], rchan[MAXSTRINGLEN];
	HANDLE hfile = NULL;
	unsigned int count;
	scriptoptnc_t nct;
	scriptopt_t t;

	tmp = data;
	table  = getword(&tmp);
        count = 0;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	if (myfileopen(&hfile, data, tmp, TRUE))
		return 3;
	wsprintf(line, "#aircdll OptTable 1 - %s", table);
	file_write(&hfile, line);
	for (nct = scriptoptstart->head; nct; nct = nct->next) {
		for (t = nct->list; t; t = t->next) {
			rflags[0] = '+';
			rflags[1] = rnetw[0] = rchan[0] = 0;
			if (nct->netw && *(nct->netw) ) {
				lstrcat(rflags, "n");
				wsprintf(rnetw, " %s", nct->netw);
			}
			if (nct->chan && *(nct->chan) ) {
				lstrcat(rflags, "c");
				wsprintf(rchan, " %s", nct->chan);
			}
			wsprintf(line, "%s%s%s %s %s", rflags, rnetw, rchan, t->item, t->cont);
			if (file_write(&hfile, line))
				count++;
		}
	}
	CloseHandle(hfile);
	wsprintf(data, "+OK %d", count);
	return 3;
}

/*
 * OptSet <table> <+[nc]> [network] [#channel] <item> [data]
 */
MircFunc OptSet (FUNCPARMS)
{
	int result = opt_intset(data);

	if (result == 1)
		r_err("TABLE", "Invalid table name");
	if (result == 2)
		r_err("FLAGS", "Invalid flags");
	if (result == 3)
		r_err("ITEM", "Invalid item name");
	r_ok("");
}

/*
 * OptDel <table> <+[nc]> [network] [#channel] <item>
 */
MircFunc OptDel (FUNCPARMS)
{
	char *tmp, *table, *flags, *netw, *chan, *item;

	tmp = data;
	table  = getword(&tmp);
        netw = chan = NULL;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	flags  = getword(&tmp);
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);
	if (!*item)
		r_err("ITEM", "Invalid item name");
	if (opt_find(netw, chan, item, NULL, FALSE, FALSE)) {
		opt_find(netw, chan, item, NULL, FALSE, TRUE);
		r_ok("");
	}
	r_err("ERR", "Setting not found");
}

/*
 * OptDelMatch <table> <+[nc]> [network|*netmask*] [#channel|*chanmask*] <*item*>
 */
MircFunc OptDelMatch (FUNCPARMS)
{
	tbool matchan = FALSE, matchnetw = FALSE;
	unsigned int count = 0;
	char *tmp, *table, *flags, *netw, *chan, *item;
	scriptoptnc_t nct, ncp = NULL, ncaux = NULL;
	scriptopt_t t = NULL, p = NULL, aux = NULL;

	tmp = data;
	table  = getword(&tmp);
        netw = chan = NULL;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	flags  = getword(&tmp);
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);
	if (!*item)
		r_err("ITEM", "Invalid item name");
	if (!chan || !*chan)
		matchan = TRUE;
	if (!netw || !*netw)
		matchnetw = TRUE;
	nct = scriptoptstart->head;
	while (nct) {
		if ( (matchan || iswm(chan, nct->chan)) && (matchnetw || iswm(netw, nct->netw)) ) {
			t = nct->list;
			p = NULL;
			aux = NULL;
			while (t) {
				if (iswm(item, t->item)) {
					if (t == nct->list) {
						nct->list = (nct->list)->next;
					} else if (p) {
						p->next = t->next;
					}
					aux = t;
					t = t->next;
					opt_delnode(aux);
					++count;
				} else {
					p = t;
					t = t->next;
				}
			}
		}
		if (!nct->list) {
			if (nct == scriptoptstart->head) {
				scriptoptstart->head = (scriptoptstart->head)->next;
			} else if (ncp) {
				ncp->next = nct->next;
			}
			ncaux = nct;
			nct = nct->next;
			opt_nc_delmembers(ncaux);
			opt_nc_delnode(ncaux);
		} else {
			ncp = nct;
			nct = nct->next;
		}
	}
	wsprintf(data, "+OK %d", count);
	return 3; /* returns "removed" */
}

/*
 * OptGet <table> <+[nc]> [network] [#channel] <item>
 */
MircFunc OptGet (FUNCPARMS)
{
	char *tmp, *table, *flags, *netw, *chan, *item;
	scriptopt_t opt;

	tmp = data;
	table = getword(&tmp);
        netw = chan = NULL;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	flags = getword(&tmp);
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);
	if (!*item)
		r_err("ITEM", "Invalid item name");
	opt = opt_find(netw, chan, item, NULL, FALSE, FALSE);
	if (opt)
		r_ok( opt->cont );
	r_err("ERR", "Setting not found");
}

/*
 * OptGets <table> <+[nc]> [network] [#channel] <item>
 */
MircFunc OptGets (FUNCPARMS)
{
	scriptopt_t found = NULL;
	char *tmp, *table, *flags, *netw, *chan, *item;

	tmp = data;
	table = getword(&tmp);
        netw = chan = NULL;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");

	flags  = getword(&tmp);
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);

	if (!*item)
		r_err("ITEM", "Invalid item name");

	if (chan && *chan) {
		if (netw && *netw)
			found = opt_find(netw, chan, item, NULL, FALSE, FALSE);
		if (!found)
			found = opt_find(NULL, chan, item, NULL, FALSE, FALSE);
	}
	if (!found && netw && *netw)
		found = opt_find(netw, NULL, item, NULL, FALSE, FALSE);
	if (!found)
		found = opt_find(NULL, NULL, item, NULL, FALSE, FALSE);

	if (found)
		r_ok( found->cont );
	r_err("ERR", "Setting not found");
}

/*
 * OptGetMatch <table> <+[nc]> [network] [#channel] <item> <N>
 */
MircFunc OptGetMatch (FUNCPARMS)
{
	tbool matchan, matchnetw;
	unsigned int count, nmatch;
	char *tmp, *table, *flags, *netw, *chan, *item, *ntmp, rflags[10], rnetw[MAXSTRINGLEN], rchan[MAXSTRINGLEN];
	scriptoptnc_t nct;
	scriptopt_t t;

	tmp = data;
	table = getword(&tmp);
        matchan = matchnetw = FALSE;
        count = nmatch = 0;
        netw = chan = NULL;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");

	flags  = getword(&tmp);
	if (isincs(flags, 'n'))
		netw = getword(&tmp);
	if (isincs(flags, 'c'))
		chan = getword(&tmp);
	item = getword(&tmp);
	ntmp = getword(&tmp);

	if (!*item)
		r_err("ITEM", "Invalid item name");

	if (!*ntmp) {
		nmatch = 1;
	} else if (!isnum(ntmp, 0)) {
		r_err("NUM", "Invalid Match Number");
	} else {
		nmatch = atolp(ntmp);
	}
	if (!chan || !*chan)
		matchan = TRUE;
	if (!netw || !*netw)
		matchnetw = TRUE;
	for (nct = scriptoptstart->head; nct; nct = nct->next) {
		if ( (matchan || iswm(chan, nct->chan)) && (matchnetw || iswm(netw, nct->netw)) ) {
			for (t = nct->list; t; t = t->next) {
				if (iswm(item, t->item)) {
					if (++count == nmatch) {
                                            rflags[0] = '+';
                                            rflags[1] = rnetw[0] = rchan[0] = 0;
						if (nct->netw && *(nct->netw)) {
							lstrcat(rflags, "n");
							wsprintf(rnetw, " %s", nct->netw);
						}
						if (nct->chan && *(nct->chan)) {
							lstrcat(rflags, "c");
							wsprintf(rchan, " %s", nct->chan);
						}
						wsprintf(data, "+OK %s %s%s%s %s", t->item, rflags, rnetw, rchan, t->cont);
						return 3;
					}
				}
			}
		}
	}
	if (nmatch == 0) {
		wsprintf(data, "+OK %d", count);
		return 3;
	}
	r_err("NOMATCH", "No match found");
}

/*
 * OptNetchan <table> <N>
 */
MircFunc OptNetchan (FUNCPARMS)
{
	unsigned int count, nmatch;
	char *tmp, *table, *ntmp, rflags[10], rnetw[MAXSTRINGLEN], rchan[MAXSTRINGLEN];
	scriptoptnc_t t;

	tmp = data;
	table = getword(&tmp);
        count = 0;
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");
	ntmp = getword(&tmp);
	if (!*ntmp) {
		nmatch = 1;
	} else if (!isnum(ntmp, 0)) {
		r_err("NUM", "Invalid Match Number");
	} else {
		nmatch = atolp(ntmp);
	}
	for (t = scriptoptstart->head; t; t = t->next) {
		if (*(t->chan) || *(t->netw)) {
			if (++count == nmatch) {
                            rflags[0] = '+';
                            rflags[1] = rnetw[0] = rchan[0] = 0;
				if (t->netw && *(t->netw)) {
					lstrcat(rflags, "n");
					lstrcpy(rnetw, t->netw);
				}
				if (t->chan && *(t->chan)) {
					lstrcat(rflags, "c");
					lstrcpy(rchan, t->chan);
				}
				wsprintf(data, "+OK %s %s %s", rflags, rnetw, rchan);
				return 3;
			}
		}
	}
	if (nmatch == 0) {
		wsprintf(data, "+OK %d", count);
		return 3;
	}
	r_err("NOMATCH", "No match found");
}

/*
 * OptCount <table>
 */
MircFunc OptCount (FUNCPARMS)
{
	char *tmp, *table;

	tmp = data;
	table = getword(&tmp);
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");

	wsprintf(data, "+OK %d", opt_getnumnodes(scriptoptstart));
	return 3;
}

/*
 * OptClear <table>
 */
MircFunc OptClear (FUNCPARMS)
{
	char *tmp, *table;

	tmp = data;
	table = getword(&tmp);
	if (!opt_header(table))
		r_err("TABLE", "Invalid table name");

	wsprintf(data, "+OK %d", opt_list_delmembers(scriptoptstart));
	return 3;
}

