/*
 *  flood.h
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */


#ifndef _FLOOD_H_
#define _FLOOD_H_

/*
 * Structures
 */

typedef struct floodnum_s {
	unsigned int count, ticks;
	struct floodnum_s *next;
} *floodnum_t;

typedef struct flood_s {
	struct floodnum_s *fnums;
	char *desc;
	unsigned int interval;
	hash_t hash;
	struct flood_s *next;
} *flood_t;

typedef struct floodopt_s {
	char *type;
	tbool state;
	unsigned int max, secs;
	hash_t ht;
	struct floodopt_s *next;
} *floodopt_t;

typedef struct floodoptnc_s {
	struct floodopt_s* list;
	char *netw;
	char *chan;
	hash_t hn, hc;
	struct floodoptnc_s *next;
} *floodoptnc_t;

/*
 * Prototypes
 */

void flood_checkfree (flood_t);
tbool flood_find (char *, unsigned int, tbool);
floodnum_t flood_numnode_create (unsigned int, unsigned int);
unsigned int flood_getcount ();
void flood_numnode_del (floodnum_t);
void flood_node_del (flood_t);
unsigned int flood_cleanup ();
int flood_bach (char *, char *, unsigned int, unsigned int, unsigned int, char *);
unsigned int flood_opt_nodes_getnum ();
unsigned int flood_opt_cleanup ();
floodoptnc_t flood_opt_nc_find (char *, char *, tbool, tbool);
floodopt_t flood_opt_find (char *, unsigned int, unsigned int, tbool, char *, char *, tbool, tbool);
void flood_opt_delnode (floodopt_t);
void flood_opt_nc_delnode (floodoptnc_t);
int flood_opt_intset (char *);



#endif /* _FLOOD_H_ */

