// All this is (c) Kamek Productions

#include "aircdll.h"

#define BUF_SIZE	1024

MircFunc EvalText(FUNCPARMS);
char *pc_eval(char *tok, char *startpos, tbool usestartpos);

//#define HASH_TABLE	"airc_parms"
//#define ELEM_FORMAT	"$hget(" HASH_TABLE ", %s)"
#define ELEM_FORMAT	"$evaltext_g(%s)"

char *Kstrchr(char *str, char chr) {
	char *p = str;

	while (TRUE) {
		if (*p == chr) return p;
		if (!*p) return NULL;
		p++;
	}
}

/* str-"chr-or-null"
		if chr is found in str, a pointer to it is returned
		if not, a pointer to the string's NULL char is returned */
char *Kstrchrn(char *str, char chr) {
	char *p = str;

	while (*p && (*p != chr)) p++;
	return p;
}

void Kstrncpy(char *dest, const char *src, UINT len) {
	UINT i;

	for (i = 0; i < len; i++) dest[i] = src[i];
}

tbool IsSpace(char *str, UINT len) {
	UINT i;

	for (i = 0; i < len; i++)
		if (str[i] != ' ') return FALSE;
	return TRUE;
}

// ###Kamek### changed how pc_fixglitches works
char *pc_fixglitches(char *str) {
	char *tok = str, *ntok, buf[BUF_SIZE];

	while (tok) {
		ntok = Kstrchrn(tok, ' ');
		if (ntok - tok == 1) {
			switch (tok[0]) {
				case '#': case '[': case ']':
				case '|': case '{': case '}':
					wsprintf(buf, "$chr(%u)%s", tok[0], &tok[1]);
					lstrcpy(tok, buf);
					ntok = Kstrchrn(tok, ' ');
			}
		}
		else if (ntok - tok > 1) {
			if (tok[0] == '$') {
				lstrcpy(&buf[2], &tok[1]);
				buf[0] = '$';
				buf[1] = '!';
				lstrcpy(tok, buf);
				ntok++;
			}
			else if (tok[0] == '%') {
				lstrcpy(buf, &tok[1]);
				lstrcpy(tok, "% $+ ");
				lstrcat(tok, pc_fixglitches(buf));
				return str;
			}
		}
		if (*ntok) tok = &ntok[1];
		else tok = NULL;
	}

	return str;
}

// find closing '>'
char *pc_findclose(char *str, tbool inside) {
	char *p = &str[2];
	UINT type, blvl = 0;

	if (inside) {
		type = 0;
		p = &str[1];
	}
	else
		switch (str[1]) {
			case '\0':	return NULL;
			case '$':		type = 2; break;
			case '%':		type = 1; break;
			default:		type = 0; p = &str[1];
		}
	// type 3: inside an identifier's parameters
	// type 4: after an identifier's parameters (can't open again)

	while (TRUE) {
		if (*p == '<') {
			p = pc_findclose(p, (type != 3)? TRUE : FALSE);
			if (!p) return NULL;
		}
		else if ((*p == '>') && !blvl) return p;
		else if (*p == '(') {
			if (type == 2) type = 3;
			blvl++;
		}
		else if (*p == ')') {
			if (blvl > 0) blvl--;
			else return NULL;
			if (!blvl && (type == 3)) type = 4;
		}
		else if ((*p == ' ') && (type != 3))
			return NULL;
		else if (!*p) return NULL;
		p++;
	}
}

// find the character that closes current parameter (')' or ',')
char *pc_findcloseparm(char *str) {
	char *p = str;
	UINT blvl = 1;

	while (TRUE) {
		if (*p == '(')
			blvl++;
		else if (*p == ')') {
			if (blvl > 0) blvl--;
			else return NULL;
			if (!blvl) return p;
		}
		else if ((*p == ',') && (blvl == 1))
			return p;
		else if (!*p) return NULL;
		p++;
	}
}

/*
char *pc_findclose(char *str) {
	UINT i = 0, lvl = 0;

	while (TRUE) {
		if (str[i] == '<') lvl++;
		else if (str[i] == '>') {
			lvl--;
			if (!lvl) return &str[i];
		}
		else if (!str[i]) return NULL;
		i++;
	}
}
*/

// parse identifier
void pc_parseid(char *id) {
	char parms[BUF_SIZE], *p = Kstrchr(id, '('), *ep, epc, *lparm;
	UINT i;

	if (!p) return;
	*p++ = '\0';
	ep = pc_findcloseparm(p);
	if (!ep) return;
	// ###tabo### Moved this 'for' here so it won't be performed
	//            if it's not needed
	for (i = 0; i < sizeof(parms); i++) parms[i] = '\0';
	while (TRUE) {
		epc = *ep;
		*ep = '\0';
		lparm = &parms[lstrlen(parms)];
		lstrcat(parms, p);
		pc_eval(lparm, NULL, FALSE);
		// ###tabo### i had to fix this, because parsing:
		//            <$gettok(<%shit>, 1, 32)>
		//            returned:
		//            $gettok(%shit,> 1, 32)
		//            now it returns:
		//            $gettok(%shit, 1, 32)
		// begin fix
		//parms[lstrlen(parms)] = epc;
		i = lstrlen(parms);
		parms[i] = epc;
		parms[i + 1] = '\0';
		// end fix
		p = &ep[1];
		if (epc == ')') break;
		ep = pc_findcloseparm(p);
		if (!ep) return;
	}
	lstrcat(parms, p);
	lstrcat(id, "(");
	lstrcat(id, parms);
}

char *pc_eval(char *tok, char *startpos, tbool usestartpos) {
	char left[BUF_SIZE], parm[BUF_SIZE], right[BUF_SIZE], *p, *np;

	//char Buf[900];
	//wsprintf(Buf, "tok = '%s', startpos = '%s', usestartpos = %u", tok, startpos, usestartpos);
	//MessageBox(NULL, Buf, NULL, MB_OK);

	// checking for <***>
	if (usestartpos && !startpos) p = NULL;
	else p = startpos? startpos : Kstrchr(tok, '<');
	if (!p) return pc_fixglitches(tok);
	np = pc_findclose(p, FALSE);
	if (!np) return pc_fixglitches(tok);

	// middle (the <var>), known as "parm" here
	Kstrncpy(parm, &p[1], np - p - 1);
	parm[np - p - 1] = '\0';

	// check for <lt> and <gt>
	//CharLower(parm);
	if (!lstrcmp(parm, "lt")) {
		lstrcpy(&p[1], &np[1]);
		return pc_eval(tok, Kstrchr(&p[1], '<'), TRUE);
	}
	else if (!lstrcmp(parm, "gt")) {
		*p = '>';
		lstrcpy(&p[1], &np[1]);
		return pc_eval(tok, Kstrchr(&p[1], '<'), TRUE);
	}

	// if there's "left"...
	if (p - tok > 0) {
		Kstrncpy(left, tok, p - tok);
		left[p - tok] = '\0';
		pc_fixglitches(left);

		//wsprintf(Buf, "'%s' %u", tok, p - tok);
		//MessageBox(NULL, Buf, NULL, MB_OK);

		if (tok[p - tok - 1] != ' ')
			lstrcat(left, " $+ ");
	}
	// else...
	else left[0] = '\0';

	// if  there's "right"...
	//   warning: this pc_eval recursive call here is messing with np,
	//   which is a substring of tok (the original parameter)
	if (np[1]) {

		if (np[1] != ' ')
			lstrcpy(right, " $+ ");
		else
			lstrcpy(right, "");
		lstrcat(right, pc_eval(&np[1], NULL, FALSE));
	}
	// else...
	else right[0] = '\0';

	// finishing
	switch (parm[0]) {
		case '$':
			pc_parseid(parm);
			wsprintf(tok, "%s%s%s", left, parm, right);
			break;

		case '%':
			wsprintf(tok, "%s%s%s", left, parm, right);
			break;

		default:
			wsprintf(tok, "%s" ELEM_FORMAT "%s", left, parm, right);
	}

	return tok;
}

MircFunc EvalText(FUNCPARMS)
{
	char text[BUF_SIZE];

	text[0] = '\0';
	if (lstrlen(data)) {
		lstrcpy(text, data);
		pc_eval(text, NULL, FALSE);
	}
	lstrcpy(data, text);
	return 3;
}

