/*
 *  aircdll.h
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */


#pragma warning(disable:4100)

#ifndef _AIRCDLL_H_
#define _AIRCDLL_H_

/*
 * This file must be #included _first_ in every .h or .c
 */

/*
 * #includes
 */


#define TABOLIB_USE_TIME
#include <windows.h>
#include "tabolib.h"

/*
 * #defines
 */

#define MAXSTRINGLEN 900
#define FUNCPARMS    HWND mWnd, HWND aWnd, char *data, char *parms, tbool show, tbool nopause
#define DLLNAME      "aircdll"
#define VERSION      "30130"
#define DLLINFO      DLLNAME " " VERSION " (C) Gustavo Picon (http://www.airc.ws)"
#define VERSIONL     DLLNAME " " VERSION
#define MircFunc     int __stdcall


/*
 * Macros
 */

#define r_ok(parms)        { wsprintf(data, "+OK %s", (parms)); return 3; }
#define r_err(code, parms) { wsprintf(data, "-%s %s", (code), (parms)); return 3; }
#define ret(parms)         { lstrcpy(data, (parms)); return 3; }
#define r_s(code, parms)   { wsprintf(data, "+%s %s", (code), (parms)); return 3; }

/*
 * Structures
 */

typedef struct {
	DWORD mVersion;
	HWND mHwnd;
	tbool mKeep;
} LOADINFO;

typedef struct stringchain_s {
	struct stringchain_s *next;
	char *data;
} *stringchain_t;

int myfileopen (HANDLE *, char *, char *, tbool);


#endif /* _AIRCDLL_H_ */

