/*
 *  aircdll.c
 *
 *  Copyright (C) 2001, 2002  Gustavo Picon
 */


#include "aircdll.h"
#include "flood.h"
#include "small.h"
#include "opt.h"
#include "users.h"


/*
 * We need this stuff
 */


extern tbool WINAPI _DllMainCRTStartup(HANDLE h, DWORD w, LPVOID v)
{
	tabolib_onload();
	return TRUE;
}


void __stdcall LoadDll(LOADINFO* l)
{
	l->mKeep = TRUE; /* we _must_ stay loaded */

	/* small.c - saving the handle of the menubar  */
	savemenubar(l->mHwnd, TRUE);

	/* users.c - calling the on init routines */
	users_init();
}

int __stdcall UnloadDll(int m)                                                                  
{
	if (!m) {
		flood_cleanup();
		flood_opt_cleanup();
		opt_cleanup();
		users_netw_cleanup(TRUE);
	}
	return 0; /* don't unload me you bastard! */
}

/*
 *
 * myfileopen(handle, data, file, write)
 *   Opens a file with read or write access.
 *   If an error ocurred, it fills the data buffer with an error message for mIRC and returns 3
 *
 *   file handle must be closed later with CloseHandle(handle);
 *
 */
int myfileopen (HANDLE *hfile, char *data, char *rawfile, tbool write)
{
	if (write) { /* openning file with write access */
        switch (file_open_write(hfile, rawfile)) {
			case ERR_TABOLIB_BADFILEBUFFER:
				r_err("FILE", "Invalid File");
			case ERR_TABOLIB_COULDNTOPENFILE:
				r_err("OPEN", "Couldn't open file.");
		}
	} else { /* openning file with read access */
        switch (file_open_read(hfile, rawfile)) {
			case ERR_TABOLIB_BADFILEBUFFER:
				r_err("FILE", "Invalid File");
			case ERR_TABOLIB_COULDNTOPENFILE:
				r_err("OPEN", "Couldn't open file.");
			case ERR_TABOLIB_FILENOTFOUND:
				r_err("NOFILE", "File not found or invalid");
		}
	}
	return 0;
}
