unit wrMiscFuncs;

interface

type
  TPoint = record
    X: Longint;
    Y: Longint;
  end;
  
  TPoint6 = array[1..6] of Integer;
  TPolyPoints = array[1..256] of TPoint;

function IntStr(Source: Integer): string;
function StrInt(Source: string; var Dest: Integer): Boolean;

function Gettok(Source: string; const C: Char; const N: Integer): string;
function Numtok(Source: string; const C: Char): Integer;

function QPos(const Find, Source: string; Index: Integer = 1): Integer;
function QReplace(const Source, Find, Rep: string): string;

function FillPoints(const Source: string; var Points: TPoint6): Boolean;
function FillPolyPoints(const Source: string; var PolyPoints: TPolyPoints; var PolyPointsNum: Integer): Boolean;

procedure SetStr(Dest: PChar; Source: string);
function StrLCopy(Dest: PChar; const Source: PChar; MaxLen: Cardinal): PChar; assembler;

implementation

// converts an integer to a string
function IntStr(Source: Integer): string;
begin
  Str(Source, Result);
end;
// converts a string to an integer, returns false if
// invalid integer value
function StrInt(Source: string; var Dest: Integer): Boolean;
var
  E: Integer;
begin
  Val(Source, Dest, E);
  Result := (E = 0);
end;

// works like mIRC's $gettok
function Gettok(Source: string; const C: Char; const N: Integer): string;
var
  SPos, Num: Integer;
begin
  while (Source[1] = C) do
    Source := Copy(Source, 2, MaxInt);
  while (Source[Length(Source)] = C) do
    Source := Copy(Source, 1, Length(Source) - 1);
  while (QPos(C + C, Source) > 0) do
    Source := QReplace(Source, C + C, C);

  Result := '';

  Num := 1;
  SPos := QPos(C, Source);
  while (SPos > 0) do
  begin
    if (Num = N) then
    begin
      Result := Copy(Source, 1, SPos - 1);
      Exit;
    end;

    Delete(Source, 1, SPos);
    Inc(Num);
    SPos := QPos(C, Source);
  end;

  if (Num = N) then
    Result := Source;
end;
function Numtok(Source: string; const C: Char): Integer;
var
  I: Integer;
begin
  Result := 1;

  while (Source[1] = C) do
    Source := Copy(Source, 2, MaxInt);
  while (Source[Length(Source)] = C) do
    Source := Copy(Source, 1, Length(Source) - 1);
  while (QPos(C + C, Source) > 0) do
    Source := QReplace(Source, C + C, C);

  for I := 1 to Length(Source) do
    if (Source[I] = C) then
      Inc(Result);
end;


// QuickPos, faster than standard Pos() -- not really needed
// for this project, but used by my QuickReplace
function QPos(const Find, Source: string; Index: Integer = 1): Integer;
var
  I, J: Integer;
  FindLen, SourceLen: Integer;
label
  NotFound;
begin
  FindLen := Length(Find);
  SourceLen := Length(Source);

  Result := 0;
  for I := Index to (SourceLen - FindLen) + 1 do
  begin
    if (Source[I] = Find[1]) and (Source[I + (FindLen - 1)] = Find[FindLen]) then
    begin
      for J := FindLen - 1 downto 2 do
      begin
        if (Source[I + (J - 1)] <> Find[J]) then goto NotFound;
      end;

      Result := I;
      Exit;

      NotFound:
    end;
  end;
end;
// QuickReplace..
function QReplace(const Source, Find, Rep: string): string;
var
  BytesToCopy, ActualResultLen, ResultLen: Integer;
  CurrentPos, LastPos: Integer;
  FindLen, ReplaceLen, SourceLen: Integer;
  LowSource, LowFind: string;
begin
  Result := '';
  FindLen := Length(Find);
  ReplaceLen := Length(Rep);
  SourceLen := Length(Source);

  LowSource := Source;
  LowFind := Find;

  if ReplaceLen <= FindLen then
    ActualResultLen := SourceLen
  else
    ActualResultLen := SourceLen + (SourceLen * ReplaceLen div FindLen) + ReplaceLen;
  SetLength(Result, ActualResultLen);

  CurrentPos := 1;
  ResultLen := 0;
  LastPos := 1;
  if (ReplaceLen > 0) then
  begin
    repeat
      CurrentPos := QPos(LowFind, LowSource, CurrentPos);

      if (CurrentPos = 0) then
        Break;

      BytesToCopy := CurrentPos - LastPos;
      Move(Source[LastPos], Result[ResultLen + 1], BytesToCopy);
      Move(Rep[1], Result[ResultLen + BytesToCopy + 1], ReplaceLen);

      ResultLen := ResultLen + BytesToCopy + ReplaceLen;
      CurrentPos := CurrentPos + FindLen;
      LastPos := CurrentPos;
    until False;
  end
  else
  begin
    repeat
      CurrentPos := QPos(LowFind, LowSource, CurrentPos);

      if (CurrentPos = 0) then
        Break;

      BytesToCopy := CurrentPos - LastPos;
      Move(Source[LastPos], Result[ResultLen + 1], BytesToCopy);

      ResultLen := ResultLen + BytesToCopy + ReplaceLen;
      CurrentPos := CurrentPos + FindLen;
      LastPos := CurrentPos;
    until False;
  end;
  Dec(LastPos);
  SetLength(Result, ResultLen + (SourceLen - LastPos));
  if (LastPos + 1 <= SourceLen) then
    Move(Source[LastPos + 1], Result[ResultLen + 1], SourceLen - LastPos);
end;

// fills array with points for region
function FillPoints(const Source: string; var Points: TPoint6): Boolean;
var
  I: Integer;
begin
  Result := False;

  if (Numtok(Source, ' ') <> 6) then
    Exit;

  for I := 1 to 6 do
  begin
    if not (StrInt(Gettok(Source, ' ', I), Points[I])) then
      Exit;
  end;

  Result := True;
end;
// fills array of points for polygon region
function FillPolyPoints(const Source: string; var PolyPoints: TPolyPoints; var PolyPointsNum: Integer): Boolean;
var
  I, N: Integer;
  X, Y: Integer;
  Point1, Point2: string;
begin
  Result := False;
  PolyPointsNum := 0;

  I := 1;
  N := Numtok(Source, ' ');
  while (I < N) do
  begin
    Point1 := Gettok(Source, ' ', I);
    Point2 := Gettok(Source, ' ', I + 1);
    if (StrInt(Point1, X)) and (StrInt(Point2, Y)) then
    begin
      PolyPoints[I div 2 + 1].X := X;
      PolyPoints[I div 2 + 1].Y := Y;
      Inc(PolyPointsNum);
      Inc(I, 2);
    end
    else
    begin
      PolyPointsNum := 0;
      Exit;
    end;
  end;

  Result := True;
end;

// converts Delphi string to null-terminated string
procedure SetStr(Dest: PChar; Source: string);
begin
  StrLCopy(Dest, PChar(Source), Length(Source));
end;

function StrLCopy(Dest: PChar; const Source: PChar; MaxLen: Cardinal): PChar; assembler;
asm
        PUSH    EDI
        PUSH    ESI
        PUSH    EBX
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     EBX,ECX
        XOR     AL,AL
        TEST    ECX,ECX
        JZ      @@1
        REPNE   SCASB
        JNE     @@1
        INC     ECX
@@1:    SUB     EBX,ECX
        MOV     EDI,ESI
        MOV     ESI,EDX
        MOV     EDX,EDI
        MOV     ECX,EBX
        SHR     ECX,2
        REP     MOVSD
        MOV     ECX,EBX
        AND     ECX,3
        REP     MOVSB
        STOSB
        MOV     EAX,EDX
        POP     EBX
        POP     ESI
        POP     EDI
end;

end.
