unit wrMain;

interface

uses
  Windows, Messages, wrMiscFuncs;

type
  LoadInfo = packed record
    mVersion: DWORD;
    mHwnd: HWND;
    mKeep: BOOL;
  end;

  TRegionMode = (rmRect, rmRoundRect, rmElliptical);
  TRegionSetMode = (rsmNew, rsmAdd, rsmDelete, rsmInvert);
  TRegionPolyMode = (rpmAlternate, rpmWinding);

const
  MY_VERSION_NUMBER = 'WinRgn v1.2';

var
  SelectedWindow: HWND;
  RegionMode: TRegionMode;

  PolyPointsNum: Integer;
  PolyPoints: TPolyPoints;
  RegionPolyMode: TRegionPolyMode;

procedure LoadDll(var Info: LoadInfo); stdcall;
function UnloadDll(mTimeout: Integer): Integer; stdcall;

function wrSelectWindow(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;

// standard region functions
function wrSetMode(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrSetRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrAddRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrDeleteRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrInvertRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;

// polygon region functions
function wrSetModePoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrSetRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrAddRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrDeleteRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrInvertRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;

function wrResetWindow(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
function wrVersion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;

implementation

procedure SetRegion(P: TPoint6; Mode: TRegionSetMode);
var
  NewRegion, OldRegion1, OldRegion2: HRGN;
  ResultRegion: HRGN;
begin
  case RegionMode of
    rmRect: NewRegion := CreateRectRgn(P[1], P[2], P[3], P[4]);
    rmElliptical: NewRegion := CreateEllipticRgn(P[1], P[2], P[3], P[4]);
    rmRoundRect: NewRegion := CreateRoundRectRgn(P[1], P[2], P[3], P[4], P[5], P[6]);
    else Exit;
  end;

  if (Mode = rsmNew) then
    SetWindowRgn(SelectedWindow, NewRegion, True)
  else
  begin
    OldRegion1 := CreateRectRgn(0, 0, 0, 0);
    OldRegion2 := CreateRectRgn(0, 0, 0, 0);
    ResultRegion := CreateRectRgn(0, 0, 0, 0);
    GetWindowRgn(SelectedWindow, OldRegion1);

    case Mode of
      rsmAdd: CombineRgn(ResultRegion, NewRegion, OldRegion1, RGN_OR);
      rsmDelete: begin
        CombineRgn(OldRegion2, NewRegion, OldRegion1, RGN_OR);
        CombineRgn(ResultRegion, NewRegion, OldRegion2, RGN_XOR);
      end;
      rsmInvert: CombineRgn(ResultRegion, NewRegion, OldRegion1, RGN_XOR);
    end;

    SetWindowRgn(SelectedWindow, ResultRegion, True);

    DeleteObject(NewRegion);
    DeleteObject(OldRegion1);
    DeleteObject(OldRegion2);    
  end;
end;

function ValidateInput(data: PChar; Mode: TRegionSetMode): Integer;
var
  Points: TPoint6;
begin
  Result := 3;
  if (RegionMode <> rmRoundRect) then
    SetStr(data, string(data) + ' 0 0');

  if not (IsWindow(SelectedWindow)) then
    SetStr(data, 'E_INVALID_WINDOW')
  else if (FillPoints(string(data), Points)) then
  begin
    SetRegion(Points, Mode);
    SetStr(data, 'S_OK');
  end
  else
    SetStr(data, 'E_INVALID_PARAMETERS');
end;

procedure LoadDll(var Info: LoadInfo); stdcall;
begin
  SelectedWindow := 0;
  RegionMode := rmRect;
  RegionPolyMode := rpmWinding;
  PolyPointsNum := 0;
end;

function UnloadDll(mTimeout: Integer): Integer; stdcall;
begin
  Result := 1;
  if (mTimeout = 1) then
    Result := 0;
end;

function wrSelectWindow(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
var
  Handle: Integer;
begin
  Result := 3;

  SelectedWindow := 0;
  if (StrInt(data, Handle)) and (IsWindow(Handle)) then
  begin
    SelectedWindow := Handle;
    SetStr(data, 'S_OK');
  end
  else
    SetStr(data, 'E_INVALID_WINDOW');
end;

function wrSetRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInput(data, rsmNew);
end;

function wrAddRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInput(data, rsmAdd);
end;

function wrDeleteRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInput(data, rsmDelete);
end;

function wrInvertRegion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInput(data, rsmInvert);
end;

function wrSetMode(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
var
  S: string;
begin
  Result := 3;

  S := string(data);

  SetStr(data, 'S_OK');
  if (S = 'rmRect') then
    RegionMode := rmRect
  else if (S = 'rmRoundRect') then
    RegionMode := rmRoundRect
  else if (S = 'rmElliptical') then
    RegionMode := rmElliptical
  else
  begin
    RegionMode := rmRect;
    SetStr(data, 'E_INVALID_MODE');
  end;
end;


procedure SetRegionPoly(Mode: TRegionSetMode);
var
  NewRegion, OldRegion1, OldRegion2: HRGN;
  ResultRegion: HRGN;
  FillMode: Integer;
begin
  FillMode := WINDING;
  case RegionPolyMode of
    rpmAlternate: FillMode := ALTERNATE;
    rpmWinding: FillMode := WINDING;
  end;
  NewRegion := CreatePolygonRgn(PolyPoints, PolyPointsNum, FillMode);

  if (Mode = rsmNew) then
    SetWindowRgn(SelectedWindow, NewRegion, True)
  else
  begin
    OldRegion1 := CreateRectRgn(0, 0, 0, 0);
    OldRegion2 := CreateRectRgn(0, 0, 0, 0);
    ResultRegion := CreateRectRgn(0, 0, 0, 0);
    GetWindowRgn(SelectedWindow, OldRegion1);

    case Mode of
      rsmAdd: CombineRgn(ResultRegion, NewRegion, OldRegion1, RGN_OR);
      rsmDelete: begin
        CombineRgn(OldRegion2, NewRegion, OldRegion1, RGN_OR);
        CombineRgn(ResultRegion, NewRegion, OldRegion2, RGN_XOR);
      end;
      rsmInvert: CombineRgn(ResultRegion, NewRegion, OldRegion1, RGN_XOR);
    end;

    SetWindowRgn(SelectedWindow, ResultRegion, True);

    DeleteObject(NewRegion);
    DeleteObject(OldRegion1);
    DeleteObject(OldRegion2);    
  end;
end;

function ValidateInputPoly(data: PChar; Mode: TRegionSetMode): Integer;
begin
  Result := 3;
  if not (IsWindow(SelectedWindow)) then
    SetStr(data, 'E_INVALID_WINDOW')
  else if (FillPolyPoints(string(data), PolyPoints, PolyPointsNum)) then
  begin
    SetRegionPoly(Mode);
    SetStr(data, 'S_OK');
  end
  else
    SetStr(data, 'E_INVALID_PARAMETERS');
end;


function wrSetModePoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
var
  S: string;
begin
  Result := 3;
  S := string(data);
  SetStr(data, 'S_OK');
  if (S = 'rpmAlternate') then
    RegionPolyMode := rpmAlternate
  else if (S = 'rpmSolid') then
    RegionPolyMode := rpmWinding
  else
  begin
    RegionPolyMode := rpmWinding;
    SetStr(data, 'E_INVALID_MODE');
  end;
end;

function wrSetRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInputPoly(data, rsmNew);
end;

function wrAddRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInputPoly(data, rsmAdd);
end;

function wrDeleteRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInputPoly(data, rsmDelete);
end;

function wrInvertRegionPoly(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := ValidateInputPoly(data, rsmInvert);
end;

function wrResetWindow(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := 3;
  if not (IsWindow(SelectedWindow)) then
    SetStr(data, 'E_INVALID_WINDOW')
  else
  begin
    SetWindowRgn(SelectedWindow, 0, True);
    SetStr(data, 'S_OK');
  end;
end;

function wrVersion(mWnd, aWnd: HWND; data, parms: PChar; show, nopause: BOOL): Integer; stdcall;
begin
  Result := 3;
  SetStr(data, MY_VERSION_NUMBER);
end;

end.
